/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.nio.handler;

import cn.tdchain.cipher.rsa.AesUtil;
import cn.tdchain.cipher.rsa.RsaUtil;
import cn.tdchain.jbcc.net.ConnectionCount;
import cn.tdchain.jbcc.rpc.io.eclc.EclcException;
import cn.tdchain.jbcc.rpc.nio.handler.NioHandshakerType;
import cn.tdchain.jbcc.rpc.nio.handler.NioServerHandler;
import cn.tdchain.jbcc.rpc.nio.server.NioRpcServer;
import cn.tdchain.tdmsp.Msp;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class NioAuthServerHandler
extends ChannelInboundHandlerAdapter {
    private NioRpcServer nioRpcServer;
    private Map<NioHandshakerType, String> temp = new HashMap<NioHandshakerType, String>();

    public NioAuthServerHandler(NioRpcServer nioRpcServer) {
        this.nioRpcServer = nioRpcServer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        String str = (String)msg;
        if (str == null || str.length() == 0) {
            ctx.close();
        }
        if (!this.temp.containsKey((Object)NioHandshakerType.HAND_1)) {
            String c_data = AesUtil.decrypt(str, this.nioRpcServer.getToken());
            String s_data = UUID.randomUUID().toString();
            String s_r_data = c_data + ";" + AesUtil.encrypt(s_data, this.nioRpcServer.getToken());
            this.temp.put(NioHandshakerType.AUTH, s_data);
            this.temp.put(NioHandshakerType.HAND_1, NioHandshakerType.HAND_1.name());
            ctx.writeAndFlush((Object)s_r_data);
            return;
        }
        if (!this.temp.containsKey((Object)NioHandshakerType.HAND_2)) {
            String s_data = this.temp.get((Object)NioHandshakerType.AUTH);
            if (!s_data.equals(str)) return;
            this.temp.put(NioHandshakerType.HAND_2, NioHandshakerType.HAND_2.name());
            ctx.writeAndFlush((Object)this.nioRpcServer.getKey().getPublicKey());
            return;
        }
        if (this.temp.containsKey((Object)NioHandshakerType.HAND_3)) return;
        String[] splits = str.split(";");
        String clientCertBase64Str = splits[0];
        String connectId = splits[1];
        X509Certificate clientCert = Msp.base64StringToCert(clientCertBase64Str);
        boolean leg = Msp.validateCert(Msp.base64StringToCert(this.nioRpcServer.getKey().getRootCertBase64String()), clientCert);
        if (!leg) throw new EclcException("noi shake  failed! Illegal certificate.");
        String clientPubliKey = RsaUtil.getPublicKey(clientCert.getPublicKey());
        this.temp.put(NioHandshakerType.CLIENT_PUBLIC_KEY, clientPubliKey);
        this.temp.put(NioHandshakerType.HAND_3, NioHandshakerType.HAND_3.name());
        String ogName = Msp.getOrganizationName(clientCert);
        if (!ConnectionCount.newInstance().checkSingle(connectId, clientPubliKey)) throw new EclcException("nio shake  failed! Illegal certificate. params");
        ConnectionCount.newInstance().handleConnection(connectId, clientPubliKey, ogName, ctx.channel());
        Attribute attr = ctx.channel().attr(AttributeKey.valueOf((String)NioHandshakerType.CONNECTIONID.name()));
        attr.set((Object)connectId);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.temp.containsKey((Object)NioHandshakerType.CLIENT_PUBLIC_KEY)) {
            Attribute attr = ctx.channel().attr(AttributeKey.valueOf((String)NioHandshakerType.CLIENT_PUBLIC_KEY.name()));
            attr.set((Object)this.temp.get((Object)NioHandshakerType.CLIENT_PUBLIC_KEY));
            ctx.channel().pipeline().addLast(new ChannelHandler[]{new NioServerHandler(this.nioRpcServer)});
            ctx.channel().pipeline().remove(NioAuthServerHandler.class);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    public NioRpcServer getNioRpcServer() {
        return this.nioRpcServer;
    }

    public void setNioRpcServer(NioRpcServer nioRpcServer) {
        this.nioRpcServer = nioRpcServer;
    }

    public Map<NioHandshakerType, String> getTemp() {
        return this.temp;
    }

    public void setTemp(Map<NioHandshakerType, String> temp) {
        this.temp = temp;
    }
}

