/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.nio.client;

import cn.tdchain.jbcc.net.nio.NioNet;
import cn.tdchain.jbcc.rpc.nio.client.NioAbstractClient;
import cn.tdchain.jbcc.rpc.nio.client.NioRpcClient;
import cn.tdchain.jbcc.rpc.nio.handler.NioHeartClientHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;

public class NioRpcHeartClient
extends NioAbstractClient {
    private NioHeartClientHandler nioHeartClientHandler;

    public NioRpcHeartClient(NioRpcClient nioRpcClient, NioNet.NioTask task) {
        super(nioRpcClient);
        this.nioHeartClientHandler = new NioHeartClientHandler(task);
        if (nioRpcClient != null && nioRpcClient.isActive()) {
            Channel channel = nioRpcClient.getChannel();
            channel.writeAndFlush((Object)"heart").addListener(future -> {
                if (future.isSuccess()) {
                    ChannelPipeline pipeline = channel.pipeline();
                    pipeline.remove(LengthFieldBasedFrameDecoder.class);
                    pipeline.remove(LengthFieldPrepender.class);
                    pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(18L, 5L, 0L, TimeUnit.SECONDS)});
                    pipeline.addLast(new ChannelHandler[]{this.nioHeartClientHandler});
                }
            });
        }
    }

    public void send(String msg) {
        if (msg == null) {
            return;
        }
        this.nioRpcClient.send(msg);
    }

    public boolean isConnected() {
        if (this.nioHeartClientHandler == null) {
            return false;
        }
        return this.nioHeartClientHandler.isConnected();
    }

    @Override
    public NioRpcClient getNioRpcClient() {
        return this.nioRpcClient;
    }

    @Override
    public void setNioRpcClient(NioRpcClient nioRpcClient) {
        this.nioRpcClient = nioRpcClient;
    }
}

