/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.nio.client;

import cn.tdchain.jbcc.rpc.nio.handler.NioAuthChannelHandler;
import cn.tdchain.jbcc.rpc.nio.handler.NioHandshakerType;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.DefaultProgressivePromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class NioRpcClient {
    private String serverPublicKey = null;
    private String clientPublicKey;
    private String address;
    private String token;
    private int port;
    private long timeout = -1L;
    private String connectionId;
    private Channel channel;

    public NioRpcClient(ChannelFactory channelFactory, String address, int port, long timeout, String token, String connectionId, String clientPublicKey) {
        this.address = address;
        this.port = port;
        this.timeout = timeout;
        this.token = token;
        this.connectionId = connectionId;
        this.clientPublicKey = clientPublicKey;
        this.channel = this.connect(channelFactory, address, port, token, clientPublicKey);
    }

    private Channel connect(ChannelFactory channelFactory, String address, int port, String token, String clientPublicKey) {
        try {
            Channel channel = channelFactory.newChannel();
            DefaultProgressivePromise promise = new DefaultProgressivePromise((EventExecutor)channel.eventLoop());
            channel.pipeline().addLast(new ChannelHandler[]{new NioAuthChannelHandler((Promise<Map<NioHandshakerType, String>>)promise, token, this.connectionId, clientPublicKey)});
            ChannelFuture future = channel.connect((SocketAddress)new InetSocketAddress(address, port)).sync();
            channel = future.channel();
            String publicKey = null;
            try {
                publicKey = (String)((Map)promise.get(3L, TimeUnit.SECONDS)).get((Object)NioHandshakerType.SERVER_PUBLIC_KEY);
                if (publicKey == null) {
                    this.close();
                    return null;
                }
                this.serverPublicKey = publicKey;
                channel.pipeline().remove(NioAuthChannelHandler.class);
                return channel;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public void send(String msg) {
        if (msg == null) {
            return;
        }
        this.channel.writeAndFlush((Object)msg);
    }

    public boolean isActive() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isActive();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public String getServerPublicKey() {
        return this.serverPublicKey;
    }
}

