/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.net.io;

import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.Key;
import cn.tdchain.jbcc.JbccTimeOutException;
import cn.tdchain.jbcc.PBFT;
import cn.tdchain.jbcc.ParameterException;
import cn.tdchain.jbcc.SoutUtil;
import cn.tdchain.jbcc.net.Net;
import cn.tdchain.jbcc.net.info.Node;
import cn.tdchain.jbcc.net.io.Request;
import cn.tdchain.jbcc.net.io.Resphone;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.RPCResult;
import cn.tdchain.jbcc.rpc.io.client.RpcClient;
import cn.tdchain.jbcc.rpc.io.client.RpcClientPool;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class IONet
implements Net {
    private HashSet<String> iptables = null;
    private Hashtable<String, Node> nodes = new Hashtable();
    private int serverPort = 18088;
    private Cipher cipher;
    private String token;
    private Key key;
    private String connectionId;
    private int minResult = 1;
    private int minOnlineNodes = 1;
    private int true_count = 0;
    private boolean status = true;
    private HashMap<String, Task> taskList = new HashMap();

    public IONet(String[] iptables, int serverPort, Cipher cipher, String token, Key key, String connectionId) {
        this.iptables = new HashSet<String>(Arrays.asList(iptables));
        this.serverPort = serverPort;
        this.cipher = cipher;
        this.token = token;
        this.key = key;
        this.connectionId = connectionId;
        this.minResult = PBFT.getMinByCount(iptables.length);
    }

    @Override
    public void addNodeToNodes(Node node) {
        if (this.nodes.get(node.getId()) == null) {
            this.nodes.put(node.getId(), node);
        } else {
            Node n = this.nodes.get(node.getId());
            n.setStatus(node.getStatus());
        }
    }

    private void asynGetNodesByIpTable() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Boolean> flag = new HashMap<String, Boolean>();
                Iterator ip_i = IONet.this.iptables.iterator();
                HashMap<String, RpcClient> clients = new HashMap<String, RpcClient>();
                while (ip_i.hasNext()) {
                    String ip = (String)ip_i.next();
                    if (ip == null || ip.length() <= 0) continue;
                    flag.put(ip, false);
                }
                while (IONet.this.status) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ip) {
                        // empty catch block
                    }
                    Iterator server_i = flag.keySet().iterator();
                    while (server_i.hasNext()) {
                        String server = null;
                        try {
                            Node node;
                            String data;
                            RPCResult r;
                            server = (String)server_i.next();
                            boolean flag_v = (Boolean)flag.get(server);
                            if (flag_v) continue;
                            RpcClient client = (RpcClient)clients.get(server);
                            if (client == null) {
                                client = new RpcClient(server, IONet.this.serverPort, 3000, IONet.this.token, IONet.this.connectionId, IONet.this.key.getLocalCertBase64String());
                                clients.put(server, client);
                            }
                            RPCMessage requesy_node = new RPCMessage();
                            requesy_node.setTarget(server);
                            requesy_node.setTargetType(RPCMessage.TargetType.REQUEST_NODE);
                            requesy_node.setSender(IONet.this.connectionId);
                            String r_str = client.sendAndReturn(requesy_node.toJsonString());
                            if (r_str == null || (r = (RPCResult)JSONObject.parseObject((String)r_str, RPCResult.class)) == null || r.getType() != RPCResult.ResultType.resphone_node || (data = r.getEntity()) == null || (node = (Node)JSONObject.parseObject((String)data, Node.class)) == null) continue;
                            if (SoutUtil.isOpenSout()) {
                                System.out.println("\u521d\u6b21\u6536\u5230node=" + node.toJSONString());
                            }
                            IONet.this.nodes.put(node.getId(), node);
                            client.close(null);
                            clients.remove(server);
                            flag.put(server, true);
                        }
                        catch (Exception e) {
                            if (SoutUtil.isOpenSout()) {
                                System.out.println("request error server ip=" + server);
                            }
                            e.printStackTrace();
                        }
                    }
                    IONet.this.true_count = 0;
                    flag.forEach((k, v) -> {
                        if (v.booleanValue()) {
                            IONet.this.true_count++;
                        }
                    });
                    if (IONet.this.true_count < IONet.this.minResult) continue;
                    break;
                }
            }
        }).start();
    }

    @Override
    public void start() {
        this.asynGetNodesByIpTable();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (IONet.this.status) {
                    try {
                        if (SoutUtil.isOpenSout()) {
                            System.out.println("Net node size=" + IONet.this.nodes.size());
                            System.out.println("Net task size=" + IONet.this.taskList.size());
                        }
                        for (String id : IONet.this.nodes.keySet()) {
                            Task t;
                            block14: {
                                Node node = (Node)IONet.this.nodes.get(id);
                                if (SoutUtil.isOpenSout()) {
                                    System.out.println("node id=" + node.getId() + "  serverip=" + node.serverIP() + "  status=" + (Object)((Object)node.getStatus()));
                                }
                                t = null;
                                t = (Task)IONet.this.taskList.get(id);
                                if (!Node.NodeStatus.DIE.equals((Object)node.getStatus())) {
                                    if (t == null) {
                                        try {
                                            t = new Task(node.serverIP(), IONet.this.serverPort, IONet.this.cipher, IONet.this.token, IONet.this.key, IONet.this.connectionId, 1);
                                            t.start();
                                            IONet.this.taskList.put(id, t);
                                            break block14;
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            continue;
                                        }
                                    }
                                    if (SoutUtil.isOpenSout()) {
                                        System.out.println("task id=" + id + "  status=" + t.status);
                                    }
                                } else {
                                    if (t != null && t.status) {
                                        t.stop();
                                        IONet.this.taskList.remove(id);
                                    }
                                    if (SoutUtil.isOpenSout()) {
                                        System.out.println("dead node id=" + node.getId());
                                    }
                                }
                            }
                            if (t == null || t.status) continue;
                            t.stop();
                            IONet.this.taskList.remove(id);
                        }
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                }
                IONet.this.taskList.forEach((k, v) -> v.stop());
            }
        }).start();
    }

    @Override
    public void request(RPCMessage msg) {
        this.taskList.forEach((k, v) -> {
            if (v != null && ((Task)v).status) {
                msg.setTarget((String)k);
                v.addRequest(msg.clone());
            }
        });
    }

    @Override
    public List<RPCResult> resphone(String messageId, long timeOut) {
        ArrayList<RPCResult> r_list = new ArrayList<RPCResult>(this.minResult + 3);
        long start = System.currentTimeMillis();
        ArrayList task_list = new ArrayList(this.taskList.size() + 3);
        this.taskList.forEach((k, v) -> {
            if (v != null) {
                task_list.add(v);
            }
        });
        while (true) {
            task_list.forEach(v -> {
                RPCResult r;
                if (v != null && (r = v.poll(messageId)) != null) {
                    r_list.add(r);
                }
            });
            if (r_list.size() >= this.minResult) break;
            if (System.currentTimeMillis() - start > timeOut) {
                if (r_list.size() >= 1) {
                    if (!SoutUtil.isOpenSout()) break;
                    System.out.println("r_list.size()=" + r_list.size());
                    break;
                }
                throw new JbccTimeOutException("jbcc request timeout:" + timeOut);
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return r_list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTaskSize() {
        HashMap<String, Task> hashMap = this.taskList;
        synchronized (hashMap) {
            return this.taskList.size();
        }
    }

    @Override
    public int getMinNodeSize() {
        this.minOnlineNodes = 0;
        this.nodes.forEach((k, v) -> {
            if (v.getStatus() == Node.NodeStatus.METRONOMER) {
                ++this.minOnlineNodes;
            }
        });
        int min = PBFT.getMinByCount(this.iptables.size());
        if (min > this.minOnlineNodes) {
            this.minOnlineNodes = min;
        }
        if (this.minOnlineNodes == 0) {
            this.minOnlineNodes = 1;
        }
        return PBFT.getMinByCount(this.minOnlineNodes);
    }

    @Override
    public List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.nodes.forEach((k, v) -> {
            if (v != null) {
                nodes.add((Node)v);
            }
        });
        return nodes;
    }

    @Override
    public void stop() {
        this.status = false;
    }

    public class Task {
        private boolean status = true;
        private RpcClientPool rpcPool;
        private Request request;
        private Resphone resphone;

        public Task(String serverHost, int serverPort, Cipher cipher, String token, Key key, String connectionId, int workerNum) {
            String serverPublicKey = null;
            try {
                this.rpcPool = new RpcClientPool(serverHost, serverPort, workerNum * 2, token, connectionId, key.getLocalCertBase64String());
                RpcClient client = this.rpcPool.getClient();
                serverPublicKey = client.getServerPublicKey();
                this.rpcPool.returnClient(client);
            }
            catch (SocketException e) {
                throw new ParameterException("get AIORpcClientPool SocketException, target ip=" + serverHost + "  :" + e.getMessage());
            }
            catch (IOException e) {
                throw new ParameterException("get AIORpcClientPool IOException, target ip=" + serverHost + "  :" + e.getMessage());
            }
            catch (Exception e) {
                throw new ParameterException("get AIORpcClientPool Exception, target ip=" + serverHost + "  :" + e.getMessage());
            }
            this.request = new Request(this, serverHost, serverPort, cipher, token, key, connectionId, workerNum, serverPublicKey);
            this.resphone = new Resphone(this, serverHost, connectionId, key, cipher, workerNum, serverPublicKey);
        }

        public void addRequest(RPCMessage msg) {
            if (this.status) {
                this.request.addRequest(msg);
            }
        }

        public RPCResult poll(String messageId) {
            return this.resphone.poll(messageId);
        }

        public boolean isStatus() {
            return this.status;
        }

        public void start() {
            this.status = true;
            this.request.start();
            this.resphone.start();
        }

        public void stop() {
            this.status = false;
            this.request.stop();
            this.resphone.stop();
            this.rpcPool.drop();
        }

        public RpcClient getClient() throws IOException, Exception {
            return this.rpcPool.getClient();
        }

        public void returnClient(RpcClient client) {
            this.rpcPool.returnClient(client);
        }
    }
}

