/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.net.info;

import com.alibaba.fastjson.JSONObject;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;

public class Node
implements Comparable<Node> {
    private String id;
    private HashSet<String> publicIPList = new HashSet();
    private HashSet<String> privateIPList = new HashSet();
    private String[] iptables = null;
    private Long start;
    private Long deadTime;
    private Long lastActiveTime;
    private NodeStatus status;
    private NodeType type;
    private String publicIP;
    private Double reputation;
    private Resource resource;
    private String name;
    private String longitude;
    private String latitude;
    private String location;
    private Double addReputationDefaultValue = 0.01;

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Node() {
    }

    public Node(String[] iptables) {
        if (iptables != null) {
            this.iptables = iptables;
        }
    }

    public void init(String publicIP) {
        this.initPrivateIPList();
        this.initId();
        if (publicIP != null && publicIP.length() > 0 && !"null".equals(publicIP)) {
            this.setPublicIP(publicIP);
        }
        this.setStatus(NodeStatus.PRE);
        this.setType(NodeType.FOLLOW_NODE);
        this.setStart(System.currentTimeMillis());
        this.setLastActiveTime(System.currentTimeMillis());
        this.setReputation(50.0);
    }

    private void initId() {
        String localHostName = "";
        try {
            localHostName = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.id = this.localIP() + "_" + localHostName;
    }

    private String localIP() {
        for (String local_ip : this.privateIPList) {
            if ("127.0.0.1".equals(local_ip)) continue;
            return local_ip;
        }
        return null;
    }

    private void initPrivateIPList() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress != null && inetAddress instanceof Inet4Address) {
                        String localip = inetAddress.getHostAddress();
                        this.privateIPList.add(localip);
                    }
                    if (inetAddress.isSiteLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.getHostAddress().indexOf(":") != -1) continue;
                    String netip = inetAddress.getHostAddress();
                    this.publicIPList.add(netip);
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public String serverIP() {
        if (this.publicIP != null && this.publicIP.length() > 0 && !"null".equals(this.publicIP)) {
            return this.publicIP;
        }
        String server = null;
        if (this.publicIPList.size() > 0) {
            for (String p_ip : this.publicIPList) {
                if (p_ip == null || p_ip.length() <= 0) continue;
                server = p_ip;
                break;
            }
        } else {
            server = this.localIP();
        }
        return server;
    }

    public String[] privateIps() {
        String[] ips = new String[this.privateIPList.size()];
        this.privateIPList.toArray(ips);
        return ips;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(NodeStatus status) {
        this.status = status;
    }

    public NodeType getType() {
        return this.type;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public Double getReputation() {
        return this.reputation;
    }

    public void setReputation(Double reputation) {
        this.reputation = reputation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HashSet<String> getPublicIPList() {
        return this.publicIPList;
    }

    public void setPublicIPList(HashSet<String> publicIPList) {
        this.publicIPList = publicIPList;
    }

    public HashSet<String> getPrivateIPList() {
        return this.privateIPList;
    }

    public void setPrivateIPList(HashSet<String> privateIPList) {
        this.privateIPList = privateIPList;
    }

    public Long getDeadTime() {
        return this.deadTime;
    }

    public void setDeadTime(Long deadTime) {
        this.deadTime = deadTime;
    }

    public String[] getIptables() {
        return this.iptables;
    }

    public void setIptables(String[] iptables) {
        this.iptables = iptables;
    }

    public String getPublicIP() {
        return this.publicIP;
    }

    public void setPublicIP(String publicIP) {
        this.publicIP = publicIP;
    }

    public Long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public void setLastActiveTime(Long lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    @Override
    public int compareTo(Node o) {
        Long count = this.start - o.getStart();
        if (count > 10000L || count < -10000L) {
            if (this.start == -1L) {
                return -1;
            }
            if (this.start < o.getStart()) {
                return -1;
            }
            if (this.start > o.getStart()) {
                return 1;
            }
            return 0;
        }
        if (this.reputation > o.reputation) {
            return -1;
        }
        if (this.reputation < o.reputation) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduceReputation() {
        Double d = this.reputation;
        synchronized (d) {
            Node node = this;
            Double d2 = node.reputation;
            Double d3 = node.reputation = Double.valueOf(node.reputation - 1.0);
        }
    }

    public String toJSONString() {
        return JSONObject.toJSONString((Object)this);
    }

    public void addPublicIp(String publicIP) {
        this.publicIPList.add(publicIP);
    }

    public boolean isLocalIp(String ip) {
        boolean flag = this.publicIPList.contains(ip);
        if (!flag) {
            flag = this.privateIPList.contains(ip);
        }
        return flag;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReputation() {
        Double d = this.reputation;
        synchronized (d) {
            Node node = this;
            node.reputation = node.reputation + this.addReputationDefaultValue;
        }
    }

    public static class Resource {
        private long totalMemory;
        private long freeMemory;
        private String osName;
        private long usedMemory;
        private int totalThread;
        private double cpuRatio;
        private long totalDisk;
        private long freeDisk;
        private long usedDisk;

        public long getTotalMemory() {
            return this.totalMemory;
        }

        public void setTotalMemory(long totalMemory) {
            this.totalMemory = totalMemory;
        }

        public long getFreeMemory() {
            return this.freeMemory;
        }

        public void setFreeMemory(long freeMemory) {
            this.freeMemory = freeMemory;
        }

        public String getOsName() {
            return this.osName;
        }

        public void setOsName(String osName) {
            this.osName = osName;
        }

        public long getUsedMemory() {
            return this.usedMemory;
        }

        public void setUsedMemory(long usedMemory) {
            this.usedMemory = usedMemory;
        }

        public int getTotalThread() {
            return this.totalThread;
        }

        public void setTotalThread(int totalThread) {
            this.totalThread = totalThread;
        }

        public double getCpuRatio() {
            return this.cpuRatio;
        }

        public void setCpuRatio(double cpuRatio) {
            this.cpuRatio = cpuRatio;
        }

        public long getTotalDisk() {
            return this.totalDisk;
        }

        public void setTotalDisk(long totalDisk) {
            this.totalDisk = totalDisk;
        }

        public long getFreeDisk() {
            return this.freeDisk;
        }

        public void setFreeDisk(long freeDisk) {
            this.freeDisk = freeDisk;
        }

        public long getUsedDisk() {
            return this.usedDisk;
        }

        public void setUsedDisk(long usedDisk) {
            this.usedDisk = usedDisk;
        }
    }

    public static enum Role {
        light,
        heavy;

    }

    public static enum NodeStatus {
        DIE,
        PRE,
        ASYN,
        METRONOMER;

    }

    public static enum NodeType {
        CREATION_NODE,
        FOLLOW_NODE;

    }
}

