/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.net;

import cn.tdchain.jbcc.rpc.MessageHandler;
import cn.tdchain.jbcc.rpc.nio.handler.NioHandshakerType;
import cn.tdchain.jbcc.rpc.nio.handler.NioHeartServerHandler;
import cn.tdchain.jbcc.rpc.nio.handler.NioServerHandler;
import cn.tdchain.tdmsp.util.Sha1Util;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConnectionCount {
    private static final ConcurrentHashMap<String, OUKey> clientKeyMap = new ConcurrentHashMap();
    private static ConnectionCount connectionCount;
    private static MessageHandler handler;
    private static ThreadPoolExecutor threadpool;

    private static void init() {
        threadpool = new ThreadPoolExecutor(10, 200, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        ScheduledExecutorService scheduled = Executors.newSingleThreadScheduledExecutor();
        ScheduledExecutorService scheduledheart = Executors.newSingleThreadScheduledExecutor();
        scheduledheart.scheduleAtFixedRate(() -> clientKeyMap.forEach((k, v) -> {
            try {
                Channel heart = v.getHeart();
                if (heart == null) {
                    long l = System.currentTimeMillis() - v.getStartTime();
                    if (l > 30000L) {
                        ConnectionCount.close(k, v);
                    }
                } else if (v.getHeartServerHandler().isTimeOut()) {
                    ConnectionCount.close(k, v);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }), 1000L, 3000L, TimeUnit.MILLISECONDS);
        scheduled.scheduleAtFixedRate(() -> clientKeyMap.forEach((k, v) -> threadpool.submit(() -> {
            try {
                Channel channel = v.getChannel();
                String result = handler.getResultMapByConnectionId((String)k, v.getClientKey());
                if (result != null) {
                    channel.writeAndFlush((Object)result);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        })), 0L, 30L, TimeUnit.MILLISECONDS);
    }

    private ConnectionCount() {
        ConnectionCount.init();
    }

    public static synchronized ConnectionCount newInstance() {
        if (connectionCount == null) {
            connectionCount = new ConnectionCount();
        }
        return connectionCount;
    }

    public synchronized void handleConnection(String conId, String ckey, String orgName, Channel channel) {
        if (clientKeyMap.containsKey(conId)) {
            OUKey ouKey = clientKeyMap.get(conId);
            ouKey.getChannels().add(channel);
            return;
        }
        clientKeyMap.forEach((k, v) -> {
            if (ckey.equals(v.getClientKey())) {
                threadpool.submit(() -> ConnectionCount.close(k, v));
            }
        });
        OUKey ouKey = new OUKey();
        ouKey.clientKey = ckey;
        ouKey.ou = orgName;
        ouKey.account = Sha1Util.sha1(ckey);
        ouKey.startTime = System.currentTimeMillis();
        ouKey.getChannels().add(channel);
        clientKeyMap.put(conId, ouKey);
    }

    public synchronized boolean checkSingle(String connid, String clientKey) {
        OUKey ouKey = clientKeyMap.get(connid);
        if (ouKey != null) {
            return ouKey.getClientKey().equals(clientKey);
        }
        return true;
    }

    public static void close(String connId, OUKey ouKey) {
        try {
            ouKey.getChannels().forEach(ch -> ch.close());
            clientKeyMap.remove(connId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getOUbyPublickey(String ckey) {
        Set<Map.Entry<String, OUKey>> entries = clientKeyMap.entrySet();
        for (Map.Entry<String, OUKey> next : entries) {
            OUKey value = next.getValue();
            if (!value.clientKey.equals(ckey)) continue;
            return value.getOu();
        }
        return null;
    }

    public OUKey getOUKey(String connId) {
        if (connId == null) {
            return null;
        }
        return clientKeyMap.get(connId);
    }

    public void handleSocket(String connId, Channel channel) {
        if (clientKeyMap.containsKey(connId)) {
            OUKey ouKey = clientKeyMap.get(connId);
            ouKey.setChannel(channel);
        } else {
            channel.close();
        }
    }

    public boolean containsKey(String connId) {
        return clientKeyMap.containsKey(connId);
    }

    public void remove(String connid) {
        clientKeyMap.remove(connid);
    }

    public ConcurrentHashMap<String, OUKey> getClientKeyMap() {
        return clientKeyMap;
    }

    public void handleHeart(Channel channel) {
        Attribute attr = channel.attr(AttributeKey.valueOf((String)NioHandshakerType.CONNECTIONID.name()));
        String connectionId = (String)attr.get();
        OUKey ouKey = clientKeyMap.get(connectionId);
        if (ouKey == null) {
            channel.close();
        } else {
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.remove(LengthFieldBasedFrameDecoder.class);
            pipeline.remove(LengthFieldPrepender.class);
            pipeline.remove(NioServerHandler.class);
            NioHeartServerHandler nioHeartServerHandler = new NioHeartServerHandler();
            pipeline.addLast(new ChannelHandler[]{nioHeartServerHandler});
            ouKey.setHeart(channel);
            ouKey.setHeartServerHandler(nioHeartServerHandler);
        }
    }

    public ConnectionCount buildHandler(MessageHandler handler) {
        if (ConnectionCount.handler == null) {
            ConnectionCount.handler = handler;
        }
        return this;
    }

    public static class OUKey {
        private String clientKey;
        private String ou;
        private String account;
        private Channel channel;
        private Channel heart;
        private long startTime;
        private NioHeartServerHandler heartServerHandler;
        private List<Channel> channels = new ArrayList<Channel>();

        public List<Channel> getChannels() {
            return this.channels;
        }

        public NioHeartServerHandler getHeartServerHandler() {
            return this.heartServerHandler;
        }

        public void setHeartServerHandler(NioHeartServerHandler heartServerHandler) {
            this.heartServerHandler = heartServerHandler;
        }

        public void setChannels(List<Channel> channels) {
            this.channels = channels;
        }

        public Channel getHeart() {
            return this.heart;
        }

        public void setHeart(Channel heart) {
            this.heart = heart;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public void setChannel(Channel channel) {
            this.channel = channel;
        }

        public String getAccount() {
            return this.account;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public String getClientKey() {
            return this.clientKey;
        }

        public void setClientKey(String clientKey) {
            this.clientKey = clientKey;
        }

        public String getOu() {
            return this.ou;
        }

        public void setOu(String ou) {
            this.ou = ou;
        }
    }
}

