/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SensitiveWordsUtil {
    public static String filePath = "sensitive-words.txt";
    public static Set<String> words;
    public static Map<String, String> wordMap;
    public static int MATCH_TYPE_MIN;
    public static int MATCH_TYPE_MAX;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> readTxtByLine(String filePath) {
        HashSet<String> keyWordSet = new HashSet<String>();
        String realPath = SensitiveWordsUtil.class.getClassLoader().getResource(filePath).getFile();
        File file = new File(realPath);
        if (!file.exists()) {
            return keyWordSet;
        }
        BufferedReader reader = null;
        String temp = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((temp = reader.readLine()) != null) {
                keyWordSet.add(temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return keyWordSet;
    }

    public static int checkSensitiveWords(String txt, int beginIndex, int matchType) {
        boolean flag = false;
        int matchFlag = 0;
        char word = '\u0000';
        Map nowMap = wordMap;
        for (int i = beginIndex; i < txt.length() && (nowMap = (Map)((Object)nowMap.get(Character.valueOf(word = txt.charAt(i))))) != null; ++i) {
            ++matchFlag;
            if (!"1".equals(nowMap.get("isEnd"))) continue;
            flag = true;
            if (MATCH_TYPE_MIN == matchType) break;
        }
        if (!flag) {
            matchFlag = 0;
        }
        return matchFlag;
    }

    public static boolean containsSensitiveWords(String txt, int matchType) {
        boolean flag = false;
        for (int i = 0; i < txt.length(); ++i) {
            int matchFlag = SensitiveWordsUtil.checkSensitiveWords(txt, i, matchType);
            if (matchFlag <= 0) continue;
            flag = true;
        }
        return flag;
    }

    public static String replaceSensitiveWords(String txt, int matchType, String replaceChar) {
        String resultTxt = txt;
        Set<String> set = SensitiveWordsUtil.getSensitiveWords(txt, matchType);
        Iterator<String> iterator = set.iterator();
        String word = null;
        String replaceString = null;
        while (iterator.hasNext()) {
            word = iterator.next();
            replaceString = SensitiveWordsUtil.getReplaceChars(replaceChar, word.length());
            resultTxt = resultTxt.replaceAll(word, replaceString);
        }
        return resultTxt;
    }

    public static Set<String> getSensitiveWords(String txt, int matchType) {
        HashSet<String> sensitiveWordList = new HashSet<String>();
        for (int i = 0; i < txt.length(); ++i) {
            int length = SensitiveWordsUtil.checkSensitiveWords(txt, i, matchType);
            if (length <= 0) continue;
            sensitiveWordList.add(txt.substring(i, i + length));
            i = i + length - 1;
        }
        return sensitiveWordList;
    }

    private static String getReplaceChars(String replaceChar, int length) {
        String resultReplace = replaceChar;
        for (int i = 1; i < length; ++i) {
            resultReplace = resultReplace + replaceChar;
        }
        return resultReplace;
    }

    private static void addSensitiveWords2Map(Set<String> keyWordSet) {
        wordMap = new HashMap<String, String>(keyWordSet.size());
        String key2 = null;
        HashMap<Object, Object> nowMap = null;
        HashMap<Object, Object> newWorMap = null;
        for (String key2 : keyWordSet) {
            nowMap = wordMap;
            for (int i = 0; i < key2.length(); ++i) {
                char keyChar = key2.charAt(i);
                String wordMap = nowMap.get(Character.valueOf(keyChar));
                if (wordMap != null) {
                    nowMap = (HashMap<Object, Object>)((Object)wordMap);
                } else {
                    newWorMap = new HashMap<Object, Object>();
                    newWorMap.put("isEnd", "0");
                    nowMap.put(Character.valueOf(keyChar), newWorMap);
                    nowMap = newWorMap;
                }
                if (i != key2.length() - 1) continue;
                nowMap.put("isEnd", "1");
            }
        }
    }

    static {
        MATCH_TYPE_MIN = 1;
        MATCH_TYPE_MAX = 2;
        words = SensitiveWordsUtil.readTxtByLine(filePath);
        SensitiveWordsUtil.addSensitiveWords2Map(words);
    }
}

