/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc;

import cn.tdchain.Block;
import cn.tdchain.Trans;
import cn.tdchain.TransHead;
import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.CipherException;
import cn.tdchain.cipher.Key;
import cn.tdchain.cipher.utils.HashCheckUtil;
import cn.tdchain.jbcc.BatchTrans;
import cn.tdchain.jbcc.BatchTransException;
import cn.tdchain.jbcc.BlockException;
import cn.tdchain.jbcc.ConnectionTimeOutException;
import cn.tdchain.jbcc.ManagerTransactionPool;
import cn.tdchain.jbcc.PBFT;
import cn.tdchain.jbcc.ParameterException;
import cn.tdchain.jbcc.SQLCheckUtil;
import cn.tdchain.jbcc.SoutUtil;
import cn.tdchain.jbcc.TransInfoException;
import cn.tdchain.jbcc.TransUtil;
import cn.tdchain.jbcc.Transaction;
import cn.tdchain.jbcc.net.Net;
import cn.tdchain.jbcc.net.NetType;
import cn.tdchain.jbcc.net.info.Node;
import cn.tdchain.jbcc.net.io.IONet;
import cn.tdchain.jbcc.net.nio.NioNet;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.RPCResult;
import cn.tdchain.tdmsp.Msp;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Connection {
    private int minSucces = 1;
    protected Key key = new Key();
    protected Net net;
    protected NetType netType = NetType.NIO;
    private String connectionId = UUID.randomUUID().toString();
    protected Cipher cipher = new Cipher();
    protected static final ScheduledExecutorService scheduledService = Executors.newSingleThreadScheduledExecutor();

    public TransHead addTrans(Trans trans) {
        if (trans == null) {
            throw new BatchTransException("trans is null");
        }
        BatchTrans<Trans> batch = new BatchTrans<Trans>();
        batch.setConnectionId(this.connectionId);
        batch.addTransToBatch(trans);
        BatchTrans<TransHead> batchTrans = this.addBatchTrans(batch);
        return batchTrans.oneTrans();
    }

    public BatchTrans<TransHead> addBatchTrans(BatchTrans<Trans> batch) {
        if (batch == null || batch.getTransSet() == null || batch.getTransSet().size() == 0) {
            throw new BatchTransException("batch is empty ");
        }
        batch.setConnectionId(this.connectionId);
        batch.check();
        RPCMessage msg = this.getMessage();
        msg.setMessageId(batch.getId());
        msg.setMsg(batch.toJsonString());
        msg.setTargetType(RPCMessage.TargetType.TX_WAIT);
        this.net.request(msg);
        List<RPCResult> rpcResultList = this.net.resphone(msg.getMessageId(), 12000L);
        int succesCount = 0;
        int failCount = 0;
        BatchTrans succesBatch = null;
        BatchTrans<TransHead> failBatch = new BatchTrans<TransHead>();
        for (RPCResult result : rpcResultList) {
            if (this.stopNext(result)) continue;
            BatchTrans tempBatch = null;
            if (result.getType() != RPCResult.ResultType.tx_status) continue;
            try {
                tempBatch = (BatchTrans)JSON.parseObject((String)result.getEntity(), (TypeReference)new TypeReference<BatchTrans<TransHead>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (tempBatch != null) {
                ++succesCount;
                succesBatch = tempBatch;
                continue;
            }
            ++failCount;
        }
        if (succesCount >= this.minSucces || succesCount > failCount) {
            return succesBatch;
        }
        failBatch.setStatus(Trans.TransStatus.failed);
        return failBatch;
    }

    public Block<Trans> getBlock(Long height) {
        Block b = null;
        if (height == null || height < 1L && height != -1L) {
            return b;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("height", height.toString());
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_BLOCK);
        this.net.request(msg);
        List<RPCResult> rpcResultList = this.net.resphone(msg.getMessageId(), 10000L);
        for (RPCResult result : rpcResultList) {
            if (this.stopNext(result) || result.getType() != RPCResult.ResultType.block) continue;
            try {
                b = (Block)JSON.parseObject((String)result.getEntity(), (TypeReference)new TypeReference<Block<Trans>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (b == null) continue;
            try {
                b.check();
            }
            catch (BlockException e) {
                e.printStackTrace();
            }
        }
        return b;
    }

    public Block getBlockHeaderByHeight(Long height) {
        Block b = null;
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("height", height.toString());
        RPCMessage msg = this.getMessage();
        msg.setCommand(command);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setTargetType(RPCMessage.TargetType.GET_BLOCK_HEADER);
        this.net.request(msg);
        List<RPCResult> r_list = this.net.resphone(msg.getMessageId(), 10000L);
        for (RPCResult r : r_list) {
            if (r == null || r.getType() != RPCResult.ResultType.block_header || r.getEntity() == null || "".equals(r.getEntity())) continue;
            try {
                b = (Block)JSON.parseObject((String)r.getEntity(), (TypeReference)new TypeReference<Block<Trans>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (b == null) continue;
            return b;
        }
        return null;
    }

    public Block<Trans> getMaxBlock() {
        return this.getBlock(-1L);
    }

    public Trans getTransByHash(String hash) {
        if (!HashCheckUtil.hashCheck(hash)) {
            return null;
        }
        if (hash.length() <= 64) {
            return null;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("hash", hash);
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_HASH);
        this.net.request(msg);
        List<RPCResult> rpcResultList = this.net.resphone(msg.getMessageId(), 3000L);
        return this.transByResult(rpcResultList);
    }

    public List<Trans> getTransListByHashList(List<String> hashList) {
        List<Trans> transList = null;
        if (hashList == null || hashList.size() == 0) {
            return new ArrayList<Trans>();
        }
        if (hashList.size() > 100) {
            throw new BatchTransException("hashList is too large [ less than or equal to 100 ] ");
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("hashList", JSONObject.toJSONString(hashList));
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_LIST);
        this.net.request(msg);
        List<RPCResult> rpcResultList = this.net.resphone(msg.getMessageId(), 6000L);
        transList = this.transListByResultList(rpcResultList);
        return transList;
    }

    public Trans getNewTransByKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        if (SQLCheckUtil.checkSQLError(key = key.trim())) {
            return null;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("key", key);
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_KEY);
        this.net.request(msg);
        List<RPCResult> rpcResultList = this.net.resphone(msg.getMessageId(), 3000L);
        return this.transByResult(rpcResultList);
    }

    public List<Trans> getTransListByType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return new ArrayList<Trans>();
        }
        if (HashCheckUtil.illegalCharacterCheck(type) || type == null || type.length() > 45) {
            throw new TransInfoException("type have Illegal character or length too long.");
        }
        List<Trans> transList = null;
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("type", type);
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_LIST_BY_TYPE);
        this.net.request(msg);
        List<RPCResult> rpcResultList = this.net.resphone(msg.getMessageId(), 6000L);
        transList = this.transListByResultList(rpcResultList);
        return transList;
    }

    public List<Trans> getTransHistoryByKey(String key, int startIndex, int endIndex) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return new ArrayList<Trans>();
        }
        List<Trans> transList = null;
        if (startIndex < 0 || startIndex > endIndex || endIndex - startIndex >= 29) {
            throw new ParameterException("startIndex < 0 || startIndex > endIndex || ((endIndex - startIndex) >= 29)");
        }
        if (SQLCheckUtil.checkSQLError(key)) {
            return new ArrayList<Trans>();
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("key", key);
        command.put("startIndex", startIndex + "");
        command.put("endIndex", endIndex + "");
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_HISTORY);
        this.net.request(msg);
        List<RPCResult> rpcResultList = this.net.resphone(msg.getMessageId(), 8000L);
        transList = this.transListByResultList(rpcResultList);
        return transList;
    }

    public int getConnectionCount() {
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setTargetType(RPCMessage.TargetType.GET_CONNECTION_COUNT);
        this.net.request(msg);
        List<RPCResult> rpcResultList = this.net.resphone(msg.getMessageId(), 8000L);
        int count = this.connectionCountByResultList(rpcResultList);
        return count;
    }

    public boolean startTransaction(String[] keys) {
        if (keys != null && keys.length > 0) {
            Transaction transaction = new Transaction(keys);
            return ManagerTransactionPool.register(transaction, 6000L);
        }
        return false;
    }

    public void stopTransaction(String[] keys) {
        if (keys != null && keys.length > 0) {
            Transaction transaction = new Transaction(keys);
            ManagerTransactionPool.destroy(transaction);
        }
    }

    public Long getTotalTransCount() {
        Long totalTransCount = 0L;
        RPCMessage msg = this.getMessage();
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setTargetType(RPCMessage.TargetType.GET_TOTAL_TRANS_COUNT);
        this.net.request(msg);
        List<RPCResult> rpcResultList = this.net.resphone(msg.getMessageId(), 5000L);
        if (rpcResultList == null || rpcResultList.size() == 0) {
            return totalTransCount;
        }
        for (RPCResult result : rpcResultList) {
            if (this.stopNext(result) || result.getType() != RPCResult.ResultType.result_list) continue;
            try {
                totalTransCount = (Long)JSONObject.parseObject((String)result.getEntity(), Long.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return totalTransCount;
    }

    public List<Node> getBlockChainNodeStatus() {
        List<Node> nodes = this.net.getNodes();
        return nodes;
    }

    public String getId() {
        return this.connectionId;
    }

    protected Connection(String[] ipArr, int port, String token, String ksPath, String ksPasswd) {
        this(ipArr, port, token, 3000L, ksPath, ksPasswd);
    }

    protected Connection(String[] ipTable, int port, Key key, String token, Cipher cipher, NetType netType) {
        this.key = key;
        this.cipher = cipher;
        this.netType = netType;
        this.minSucces = PBFT.getMinByCount(ipTable.length);
        this.openNet(ipTable, port, token, cipher);
        this.asynAskNodes(3000L);
    }

    protected Connection(String[] ipTable, int port, Key key, String token, Cipher cipher) {
        this(ipTable, port, key, token, cipher, NetType.NIO);
    }

    protected Connection(String[] ipArr, int port, String token, long timeout, String ksPath, String ksPasswd) {
        this(ipArr, port, token, timeout, ksPath, ksPasswd, NetType.NIO);
    }

    protected Connection(String[] ipArr, int port, String token, long timeout, String ksPath, String ksPasswd, NetType netType) {
        this.netType = netType;
        this.minSucces = PBFT.getMinByCount(ipArr.length);
        this.readyCert(ksPath, ksPasswd);
        this.openNet(ipArr, port, token);
        this.asynAskNodes(timeout);
    }

    protected RPCMessage getMessage() {
        RPCMessage msg = new RPCMessage();
        msg.setSender(this.connectionId);
        return msg;
    }

    private int connectionCountByResultList(List<RPCResult> rpcResultList) {
        if (CollectionUtils.isEmpty(rpcResultList)) {
            return 0;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (RPCResult result : rpcResultList) {
            if (this.stopNext(result) || result.getType() != RPCResult.ResultType.connection_count) continue;
            try {
                int count = Integer.parseInt(result.getEntity());
                list.add(count);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (list.size() >= this.minSucces || list.size() >= rpcResultList.size() / 2) {
            Map<Integer, Long> collect = list.stream().collect(Collectors.groupingBy(i -> i, Collectors.counting()));
            Long max = Collections.max(collect.values());
            List sameList = collect.entrySet().stream().filter(en -> ((Long)en.getValue()).longValue() == max.longValue()).collect(Collectors.toList());
            if (sameList.size() >= list.size() / 2) {
                int sum = list.stream().mapToInt(t -> t).sum();
                return sum / list.size();
            }
            return (Integer)((Map.Entry)sameList.get(0)).getKey();
        }
        return 0;
    }

    private Trans transByResult(List<RPCResult> rpcResultList) {
        if (rpcResultList == null || rpcResultList.size() == 0) {
            return null;
        }
        int succesCount = 0;
        int failCount = 0;
        Trans succesTrans = null;
        Trans failTrans = null;
        for (RPCResult result : rpcResultList) {
            if (this.stopNext(result)) continue;
            Trans tempTrans = null;
            if (result.getType() != RPCResult.ResultType.tx_status) continue;
            try {
                tempTrans = (Trans)JSONObject.parseObject((String)result.getEntity(), Trans.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (tempTrans != null && TransUtil.getTransHash(tempTrans).equals(tempTrans.getHash())) {
                ++succesCount;
                succesTrans = tempTrans;
                continue;
            }
            ++failCount;
            failTrans = tempTrans;
        }
        if (succesCount >= this.minSucces || succesCount > failCount) {
            return succesTrans;
        }
        return failTrans;
    }

    private List<Trans> transListByResultList(List<RPCResult> rpcResultList) {
        List transList = null;
        for (RPCResult result : rpcResultList) {
            if (this.stopNext(result) || result.getType() != RPCResult.ResultType.tx_list) continue;
            try {
                transList = JSON.parseArray((String)result.getEntity(), Trans.class);
                if (transList == null) continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return transList;
    }

    private boolean stopNext(RPCResult result) {
        return result == null || StringUtils.isBlank((CharSequence)result.getEntity());
    }

    protected void openNet(String[] ipArr, int port, String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ParameterException("token is empty ");
        }
        if (this.netType == null) {
            this.netType = NetType.NIO;
        }
        switch (this.netType) {
            case IO: {
                this.net = new IONet(ipArr, port, this.cipher, token, this.key, this.connectionId);
                break;
            }
            case NIO: {
                this.net = new NioNet(ipArr, port, this.cipher, token, this.key, this.connectionId);
                break;
            }
            default: {
                this.net = new NioNet(ipArr, port, this.cipher, token, this.key, this.connectionId);
            }
        }
        this.net.start();
        Long start = System.currentTimeMillis();
        while (this.net.getTaskSize() < this.net.getMinNodeSize()) {
            if (System.currentTimeMillis() - start >= 20000L) {
                this.net.stop();
                throw new ConnectionTimeOutException("Connection time out, iptables=" + StringUtils.join((Object[])ipArr, (String)", ") + ",port=" + port + ",token=" + token);
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void openNet(String[] ipArr, int port, String token, Cipher cipher) {
        this.cipher = cipher;
        this.openNet(ipArr, port, token);
    }

    protected void asynAskNodes(long timeout) {
        scheduledService.scheduleAtFixedRate(() -> {
            RPCMessage msg = this.getMessage();
            msg.setTargetType(RPCMessage.TargetType.GET_NODE_LIST);
            msg.setMessageId(UUID.randomUUID().toString());
            this.net.request(msg);
            List nodes = new ArrayList();
            List<RPCResult> rpcResultList = this.net.resphone(msg.getMessageId(), timeout);
            for (RPCResult result : rpcResultList) {
                List nodeList;
                if (this.stopNext(result) || result.getType() != RPCResult.ResultType.node_list || (nodeList = JSONObject.parseArray((String)result.getEntity(), Node.class)) == null || nodeList.size() <= 0 || nodeList.size() <= nodes.size()) continue;
                nodes = nodeList;
            }
            if (nodes != null && nodes.size() > 0) {
                for (Node node : nodes) {
                    if (SoutUtil.isOpenSout()) {
                        System.out.println("copy node id:" + node.getId() + " status=" + (Object)((Object)node.getStatus()));
                    }
                    this.net.addNodeToNodes(node);
                }
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }, 0L, 3L, TimeUnit.SECONDS);
    }

    protected void readyCert(String ksPath, String ksPasswd) {
        try {
            String alias = Msp.ORGANIZATION_ALIAS;
            KeyStore keyStore = Msp.getKeyStore(ksPath, ksPasswd);
            String privateKey = this.cipher.getPrivateKeyStringByKeyStore(keyStore, ksPasswd, alias);
            String publicKey = this.cipher.getPublicKeyStringByStore(keyStore, ksPasswd, alias);
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            String certBase64String = Msp.certToBase64String(cert);
            this.key.setPrivateKey(privateKey);
            this.key.setPublicKey(publicKey);
            this.key.setLocalCertBase64String(certBase64String);
        }
        catch (Exception e) {
            throw new CipherException("get private key by key store error:" + e.getMessage());
        }
    }
}

