/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.rsa;

import java.lang.reflect.Array;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static byte[] subarray(byte[] data, int startIndexInclusive, int endIndexExclusive) {
        if (data == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > data.length) {
            endIndexExclusive = data.length;
        }
        int newSize = endIndexExclusive - startIndexInclusive;
        Class<?> type = data.getClass().getComponentType();
        if (newSize <= 0) {
            byte[] emptyArray = (byte[])Array.newInstance(type, 0);
            return emptyArray;
        }
        byte[] subarray = (byte[])Array.newInstance(type, newSize);
        System.arraycopy(data, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static byte[] addAll(byte[] enBytes, byte ... tmpData) {
        if (enBytes == null) {
            return ArrayUtils.clone(tmpData);
        }
        if (tmpData == null) {
            return ArrayUtils.clone(enBytes);
        }
        Class<?> type1 = enBytes.getClass().getComponentType();
        byte[] joinedArray = (byte[])Array.newInstance(type1, enBytes.length + tmpData.length);
        System.arraycopy(enBytes, 0, joinedArray, 0, enBytes.length);
        try {
            System.arraycopy(tmpData, 0, joinedArray, enBytes.length, tmpData.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type2 = tmpData.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName(), ase);
            }
            throw ase;
        }
        return joinedArray;
    }

    public static byte[] clone(byte[] enBytes) {
        if (enBytes == null) {
            return null;
        }
        return (byte[])enBytes.clone();
    }
}

