package cn.tdchain.tdmsp.util;

import cn.tdchain.cipher.Key;
import cn.tdchain.cipher.rsa.RsaUtil;
import cn.tdchain.tdmsp.Msp;
import org.apache.commons.codec.digest.DigestUtils;

import java.security.cert.X509Certificate;

public class MemberUtil {

    public static String generateAccount(Key key) {
        X509Certificate clientCert = Msp.base64StringToCert(key.getLocalCertBase64String());
        String clientPubliKey = RsaUtil.getPublicKey(clientCert.getPublicKey());
        return generateAccount(clientPubliKey);
    }

    public static String generateAccount(String publickey) {
        return "0x" + DigestUtils.md5Hex(publickey);
    }

    public static String generateRole(Key key) {
        X509Certificate clientCert = Msp.base64StringToCert(key.getLocalCertBase64String());
        String organizationName = Msp.getOrganizationName(clientCert);
        return organizationName;
    }
    
}
