/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.tdmsp.manage;

import cn.tdchain.tdmsp.ca.config.MspConfig;
import cn.tdchain.tdmsp.manage.TdMSPAcl;
import cn.tdchain.tdmsp.util.IOUtils;
import cn.tdchain.tdmsp.util.PkiUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.security.KeyStore;
import java.security.cert.X509Certificate;

public class TdMSPManage {
    private static final String ACLPATH = "./src/main/resources/acl.json";
    private static MspConfig mspConfig;
    private static TdMSPAcl tdMSPAcl;

    public MspConfig getMspConfig() {
        return mspConfig;
    }

    public TdMSPAcl getTdMSPAcl() {
        return tdMSPAcl;
    }

    public static TdMSPAcl initMspAcl() {
        byte[] jsonByte = IOUtils.getBytes(ACLPATH);
        tdMSPAcl = (TdMSPAcl)JSON.parseObject((byte[])jsonByte, TdMSPAcl.class, (Feature[])new Feature[]{Feature.IgnoreAutoType});
        return tdMSPAcl;
    }

    public static MspConfig initLocalMsp() {
        mspConfig = MspConfig.getInstance();
        return mspConfig;
    }

    public static boolean checkCert(MspConfig mspConfig) {
        boolean result = false;
        X509Certificate rootCert = PkiUtil.getCertFromCer(mspConfig.getRootCertPath());
        try {
            KeyStore keyStore = PkiUtil.getKeyStore(mspConfig.getKeyStorePath(), mspConfig.getKeyStorePassword(), "PKCS12");
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(mspConfig.getCertAlias());
            cert.verify(rootCert.getPublicKey());
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

