/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.nio.client;

import cn.tdchain.jbcc.rpc.nio.client.NioAbstractClient;
import cn.tdchain.jbcc.rpc.nio.client.NioRpcClient;
import cn.tdchain.jbcc.rpc.nio.handler.NioSynReponseClientHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.DefaultProgressivePromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.ExecutionException;

public class NioRpcSynResponseClient
extends NioAbstractClient {
    public NioRpcSynResponseClient(NioRpcClient nioRpcClient) {
        super(nioRpcClient);
        if (nioRpcClient != null && nioRpcClient.isActive()) {
            this.nioRpcClient.getChannel().pipeline().addLast(new ChannelHandler[]{new NioSynReponseClientHandler()});
        }
    }

    public synchronized String sendAndReturn(String message) throws InterruptedException {
        return this.sendAndReturn(message, 1000L);
    }

    public synchronized String sendAndReturn(String message, long timeMillis) throws InterruptedException {
        if (message == null) {
            return null;
        }
        Channel channel = this.nioRpcClient.getChannel();
        NioSynReponseClientHandler nioSynReponseClientHandler = (NioSynReponseClientHandler)channel.pipeline().get(NioSynReponseClientHandler.class);
        if (nioSynReponseClientHandler == null) {
            return null;
        }
        Promise<String> oldPromise = nioSynReponseClientHandler.getPromise();
        if (oldPromise != null && !oldPromise.isDone()) {
            try {
                oldPromise.await(timeMillis);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                oldPromise.tryFailure(e.getCause());
            }
        }
        DefaultProgressivePromise promise = new DefaultProgressivePromise((EventExecutor)channel.eventLoop());
        nioSynReponseClientHandler.setPromise((Promise<String>)promise);
        channel.writeAndFlush((Object)message);
        try {
            promise.await(timeMillis);
            if (promise.isSuccess()) {
                return (String)promise.get();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return null;
    }
}

