/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.io.eclc;

import cn.tdchain.cipher.Key;
import cn.tdchain.cipher.rsa.AesUtil;
import cn.tdchain.cipher.rsa.RsaUtil;
import cn.tdchain.jbcc.ConnectionManager;
import cn.tdchain.jbcc.SoutUtil;
import cn.tdchain.jbcc.rpc.BlackList;
import cn.tdchain.jbcc.rpc.io.eclc.ClientSocket;
import cn.tdchain.jbcc.rpc.io.eclc.EclcException;
import cn.tdchain.tdmsp.Msp;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.UUID;

public class EclcServerSocket
extends ServerSocket {
    private Key key = null;
    private String passwd = "1234567890123456";
    private long timeOut = 5000L;

    public EclcServerSocket(int port, String passwd, Key key) throws IOException {
        super(port);
        this.passwd = passwd;
        this.key = key;
    }

    public EclcServerSocket(int port, int backlog, InetAddress bindAddr, String passwd, Key key) throws IOException {
        super(port, backlog, bindAddr);
        this.passwd = passwd;
        this.key = key;
    }

    public EclcServerSocket(int port, int backlog, String passwd, Key key) throws IOException {
        super(port, backlog);
        this.passwd = passwd;
        this.key = key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClientSocket accept2() throws IOException {
        ClientSocket clientSocket = null;
        Socket client = super.accept();
        if (!client.isConnected()) throw new EclcException("Eclc  failed! client is not connection.");
        if (BlackList.isBlackListByHost(client.getLocalAddress().getHostAddress())) {
            if (client == null) throw new EclcException("Eclc  failed! this host is a blacklist.");
            client.close();
            throw new EclcException("Eclc  failed! this host is a blacklist.");
        }
        OutputStreamWriter os = new OutputStreamWriter(client.getOutputStream());
        BufferedWriter bwrite = new BufferedWriter(os);
        InputStreamReader ir = new InputStreamReader(client.getInputStream());
        BufferedReader bread = new BufferedReader(ir);
        Result result1 = new Result();
        try {
            this.waitLine(result1, bread);
        }
        catch (Exception e) {
            BlackList.addBlackListByHost(client.getLocalAddress().getHostAddress());
            if (client == null) throw new EclcException(e.getMessage());
            client.close();
            throw new EclcException(e.getMessage());
        }
        String c_data = AesUtil.decrypt(result1.line, this.passwd);
        String s_data = UUID.randomUUID().toString();
        String s_r_data = c_data + ";" + AesUtil.encrypt(s_data, this.passwd);
        bwrite.write(s_r_data);
        bwrite.newLine();
        bwrite.flush();
        Result result2 = new Result();
        try {
            this.waitLine(result2, bread);
        }
        catch (Exception e) {
            BlackList.addBlackListByHost(client.getLocalAddress().getHostAddress());
            if (client == null) throw new EclcException(e.getMessage());
            client.close();
            throw new EclcException(e.getMessage());
        }
        if (s_data.equals(result2.line)) {
            String keyAndConnId = bread.readLine();
            String[] splits = keyAndConnId.split(";");
            String clientCertBase64Str = splits[0];
            String connectId = splits[1];
            if (clientCertBase64Str == null || clientCertBase64Str.length() == 0) {
                throw new EclcException("Eclc  failed! null certificate.");
            }
            X509Certificate clientCert = Msp.base64StringToCert(clientCertBase64Str);
            boolean leg = Msp.validateCert(Msp.base64StringToCert(this.key.getRootCertBase64String()), clientCert);
            if (!leg) throw new EclcException("Eclc  failed! Illegal certificate.");
            String clientPubliKey = RsaUtil.getPublicKey(clientCert.getPublicKey());
            clientSocket = new ClientSocket(client, clientPubliKey);
            if (SoutUtil.isOpenSout()) {
                System.out.println(connectId + "::::::::::::" + clientCertBase64Str);
            }
            String orgName = Msp.getOrganizationName(clientCert);
            if (!ConnectionManager.newInstance().checkSingle(connectId, clientPubliKey)) {
                throw new EclcException("Eclc shake  failed! Illegal certificate. params");
            }
            ConnectionManager.newInstance().handleConnection(connectId, clientPubliKey, orgName, null);
        } else {
            BlackList.addBlackListByHost(client.getLocalAddress().getHostAddress());
            if (client == null) throw new EclcException("Eclc  failed! passwd is not agreement.");
            client.close();
            throw new EclcException("Eclc  failed! passwd is not agreement.");
        }
        bwrite.write(this.key.getPublicKey());
        bwrite.newLine();
        bwrite.flush();
        client.setSoTimeout(0);
        return clientSocket;
    }

    private void waitLine(final Result result, final BufferedReader bread) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    result.line = bread.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.timeOut && (result.line == null || result.line.length() <= 0)) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (result.line == null) {
            throw new EclcException("read time out.");
        }
    }

    class Result {
        public String line;

        Result() {
        }
    }
}

