/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.io.client;

import cn.tdchain.jbcc.rpc.io.client.RpcClient;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class RpcClientPool {
    private String token = "tiande@123456AbC";
    private String localPublicKey = null;
    private int maxPoolSize = 16;
    private String addres;
    private int port;
    private int timeOut = 1000;
    private String connectionId;
    private ConcurrentLinkedQueue<RpcClient> clientPool = new ConcurrentLinkedQueue();

    public RpcClientPool(String addres, int port, String token, String connectionId, String localPublicKey) throws IOException, Exception {
        this(addres, port, 16, 1000, token, connectionId, localPublicKey);
    }

    public RpcClientPool(String addres, int port, int maxPoolSize, String token, String connectionId, String localPublicKey) throws IOException, Exception {
        this(addres, port, maxPoolSize, 2000, token, connectionId, localPublicKey);
    }

    public RpcClientPool(String addres, int port, int maxPoolSize, int timeOut, String token, String connectionId, String localPublicKey) throws IOException, Exception {
        this.addres = addres;
        this.port = port;
        this.maxPoolSize = maxPoolSize;
        this.timeOut = timeOut;
        this.token = token;
        this.localPublicKey = localPublicKey;
        this.connectionId = connectionId;
        for (int i = 0; i < this.maxPoolSize; ++i) {
            this.newClient();
        }
    }

    private void newClient() throws IOException, Exception {
        if (this.clientPool.size() < this.maxPoolSize) {
            RpcClient client = new RpcClient(this.addres, this.port, this.timeOut, this.token, this.connectionId, this.localPublicKey);
            this.clientPool.add(client);
        }
    }

    public synchronized RpcClient getClient() throws IOException, Exception {
        if (this.clientPool.size() < 1) {
            this.newClient();
        }
        return this.clientPool.poll();
    }

    public synchronized void returnClient(RpcClient client) {
        if (client == null) {
            return;
        }
        if (this.clientPool.size() < this.maxPoolSize) {
            this.clientPool.add(client);
        } else {
            client.close(null);
        }
    }

    public void drop() {
        while (this.clientPool.size() > 0) {
            RpcClient client = this.clientPool.poll();
            client.close(null);
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public String getAddres() {
        return this.addres;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeOut() {
        return this.timeOut;
    }
}

