/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.net.nio;

import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.Key;
import cn.tdchain.jbcc.TimerUtil;
import cn.tdchain.jbcc.net.nio.NioNet;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.RPCResult;
import cn.tdchain.jbcc.rpc.nio.client.NioRpcResponseClient;
import cn.tdchain.jbcc.rpc.nio.handler.NioResponseClientHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NioResphone {
    private NioNet.NioTask task;
    private String ip;
    private int workerNum = 1;
    private NioResphonePool pool;
    private Cipher cipher;
    private Key key;
    private boolean status = true;
    private String connectionId;
    private String serverPublicKey;

    public NioResphone(NioNet.NioTask task, String serverIp, String connectionId, Key key, Cipher cipher, int workerNum, String serverPublicKey) {
        this.task = task;
        this.ip = serverIp;
        this.connectionId = connectionId;
        this.key = key;
        this.cipher = cipher;
        if (workerNum > this.workerNum) {
            this.workerNum = workerNum;
        }
        this.serverPublicKey = serverPublicKey;
        this.pool = new NioResphonePool(task);
    }

    public void start() {
        this.pool.start();
        if (this.status) {
            RPCMessage batch_msg = new RPCMessage();
            batch_msg.setTarget(this.ip);
            batch_msg.setTargetType(RPCMessage.TargetType.BATCH_RESPHONE);
            batch_msg.setSender(this.connectionId);
            try {
                NioRpcResponseClient client = TimerUtil.exec(0L, 5, () -> {
                    NioRpcResponseClient nc = this.task.getClient(NioRpcResponseClient.class);
                    if (nc == null || !nc.isActive()) {
                        return null;
                    }
                    return nc;
                });
                if (client == null) {
                    this.task.stop();
                    return;
                }
                NioResponseClientHandler clientHandler = (NioResponseClientHandler)client.getNioRpcClient().getChannel().pipeline().get(NioResponseClientHandler.class);
                clientHandler.setNioResphone(this);
                clientHandler.setTask(this.task);
                client.send(batch_msg.toJsonString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        this.status = false;
        this.pool.stop();
    }

    public RPCResult poll(String messageId) {
        return this.pool.poll(messageId);
    }

    public NioNet.NioTask getTask() {
        return this.task;
    }

    public void setTask(NioNet.NioTask task) {
        this.task = task;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getWorkerNum() {
        return this.workerNum;
    }

    public void setWorkerNum(int workerNum) {
        this.workerNum = workerNum;
    }

    public NioResphonePool getPool() {
        return this.pool;
    }

    public void setPool(NioResphonePool pool) {
        this.pool = pool;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public void setCipher(Cipher cipher) {
        this.cipher = cipher;
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getServerPublicKey() {
        return this.serverPublicKey;
    }

    public void setServerPublicKey(String serverPublicKey) {
        this.serverPublicKey = serverPublicKey;
    }

    public class NioResphonePool {
        private NioNet.NioTask task;
        private boolean status = true;
        private ConcurrentHashMap<String, RPCResult> resphonePool = new ConcurrentHashMap();

        public NioResphonePool(NioNet.NioTask task) {
            this.task = task;
        }

        public RPCResult poll(String messageId) {
            try {
                return this.resphonePool.remove(messageId);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public synchronized void add(Map<String, RPCResult> connectionMap) {
            this.resphonePool.putAll(connectionMap);
        }

        public void stop() {
            this.status = false;
        }

        public void start() {
            this.status = true;
            this.checkTimeOut(4000L);
        }

        private void checkTimeOut(long timeOut) {
            new Thread(() -> {
                while (this.status) {
                    long now_time = System.currentTimeMillis();
                    try {
                        RPCResult error_r = this.resphonePool.remove(RPCResult.PRC_RESULT_DESCRYPT_ERROR);
                        if (error_r != null && error_r.getStatus() == RPCResult.StatusType.fail) {
                            this.task.stop();
                            return;
                        }
                        this.resphonePool.forEach((k, v) -> {
                            if (v != null && now_time - v.getStartTime() > timeOut) {
                                this.resphonePool.remove(v.getMessageId());
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(timeOut * 2L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }).start();
        }
    }
}

