/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.net.nio;

import cn.tdchain.RPCResultJSONObject;
import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.Key;
import cn.tdchain.jbcc.PBFT;
import cn.tdchain.jbcc.ParameterException;
import cn.tdchain.jbcc.Result;
import cn.tdchain.jbcc.SoutUtil;
import cn.tdchain.jbcc.net.Net;
import cn.tdchain.jbcc.net.info.Node;
import cn.tdchain.jbcc.net.nio.NioRequest;
import cn.tdchain.jbcc.net.nio.NioResphone;
import cn.tdchain.jbcc.rpc.RPCBatchResult;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.RPCResult;
import cn.tdchain.jbcc.rpc.nio.client.NioRpcClient;
import cn.tdchain.jbcc.rpc.nio.client.NioRpcClientPool;
import cn.tdchain.jbcc.rpc.nio.client.NioRpcHeartClient;
import cn.tdchain.jbcc.rpc.nio.client.NioRpcResponseClient;
import cn.tdchain.jbcc.rpc.nio.client.NioRpcSynResponseClient;
import cn.tdchain.jbcc.rpc.nio.handler.NioPoolableRpcClientFactory;
import cn.tdchain.jbcc.rpc.nio.handler.NioRpcChannelFactory;
import cn.tdchain.jbcc.rpc.nio.handler.NioRpcClientPoolConfig;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class NioNet
implements Net {
    private final Bootstrap bootstrap;
    private EventLoopGroup workGroup;
    private boolean status = true;
    private HashSet<String> iptables;
    private Hashtable<String, Node> nodes = new Hashtable();
    private int serverPort;
    private Cipher cipher;
    private String token;
    private Key key;
    private String connectionId;
    private int minResult = 1;
    private int minOnlineNodes = 1;
    private int true_count = 0;
    private NioRpcChannelFactory nioRpcChannelFactory;
    private Map<String, NioTask> taskList = new ConcurrentHashMap<String, NioTask>();

    public NioNet(String[] iptables, int serverPort, Cipher cipher, String token, Key key, String connectionId) {
        this.iptables = new HashSet<String>(Arrays.asList(iptables));
        this.serverPort = serverPort;
        this.cipher = cipher;
        this.token = token;
        this.key = key;
        this.connectionId = connectionId;
        this.minResult = PBFT.getMinByCount(iptables.length);
        this.bootstrap = new Bootstrap();
        this.workGroup = new NioEventLoopGroup();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.workGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
                ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4)}).addLast(new ChannelHandler[]{new LengthFieldPrepender(4)}).addLast(new ChannelHandler[]{new StringDecoder(CharsetUtil.UTF_8)}).addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
            }
        });
        this.nioRpcChannelFactory = new NioRpcChannelFactory(this.bootstrap);
    }

    @Override
    public void start() {
        this.asynGetNodesByIpTable();
        new Thread(() -> {
            while (this.status) {
                try {
                    if (SoutUtil.isOpenSout()) {
                        System.out.println("Net node size=" + this.nodes.size());
                        System.out.println("Net task size=" + this.taskList.size());
                    }
                    for (String id : this.nodes.keySet()) {
                        NioTask t;
                        Node node = this.nodes.get(id);
                        if (SoutUtil.isOpenSout()) {
                            System.out.println("node id=" + node.getId() + "  serverip=" + node.serverIP() + "  status=" + (Object)((Object)node.getStatus()));
                        }
                        if ((t = this.taskList.get(id)) != null && !t.status) {
                            t.stop();
                            this.taskList.remove(id);
                            t = null;
                        }
                        if (!Node.NodeStatus.DIE.equals((Object)node.getStatus()) && !Node.NodeStatus.OUT.equals((Object)node.getStatus())) {
                            if (t == null) {
                                if (this.taskList.size() < this.minResult || Node.NodeStatus.METRONOMER.equals((Object)node.getStatus())) {
                                    try {
                                        t = new NioTask(node.serverIP(), this.serverPort, this.cipher, this.token, this.key, this.connectionId, 1);
                                        t.start();
                                        this.taskList.put(id, t);
                                    }
                                    catch (Exception e) {
                                        t = null;
                                        e.printStackTrace();
                                        continue;
                                    }
                                }
                            } else {
                                if (Node.NodeStatus.ASYN.equals((Object)node.getStatus())) {
                                    t.stop();
                                    this.taskList.remove(id);
                                }
                                if (SoutUtil.isOpenSout()) {
                                    System.out.println("task id=" + id + "  status=" + t.status);
                                }
                            }
                        } else {
                            if (t != null && t.status) {
                                t.stop();
                                this.taskList.remove(id);
                            }
                            if (SoutUtil.isOpenSout()) {
                                System.out.println("dead node id=" + node.getId());
                            }
                        }
                        if (t == null || t.status) continue;
                        t.stop();
                        this.taskList.remove(id);
                    }
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {}
            }
            this.taskList.forEach((k, v) -> v.stop());
        }).start();
    }

    @Override
    public void request(RPCMessage msg) {
        this.taskList.forEach((k, v) -> {
            if (v != null && ((NioTask)v).status) {
                msg.setTarget((String)k);
                v.addRequest(msg.clone());
            }
        });
    }

    @Override
    public RPCBatchResult resphone(String messageId, long timeOut) {
        RPCBatchResult rpcBatchResult = RPCBatchResult.newInstance();
        long start = System.currentTimeMillis();
        ArrayList task_list = new ArrayList(this.taskList.size() + 3);
        this.taskList.forEach((k, v) -> {
            if (v != null) {
                task_list.add(v);
            }
        });
        while (true) {
            task_list.forEach(v -> {
                RPCResult r;
                if (v != null && (r = v.poll(messageId)) != null) {
                    Result result = new Result();
                    result.setStatus(r.getStatus());
                    result.setEntity(r.getEntity());
                    result.setMsg(r.getMsg());
                    rpcBatchResult.add(result);
                }
            });
            if (rpcBatchResult.size() >= this.minResult) break;
            if (System.currentTimeMillis() - start > timeOut) {
                if (rpcBatchResult.size() >= 1) {
                    if (!SoutUtil.isOpenSout()) break;
                    System.out.println("r_list.size()=" + rpcBatchResult.size());
                    break;
                }
                rpcBatchResult.isTimeOut(true);
                return rpcBatchResult;
            }
            long count = this.taskList.values().stream().filter(t -> t.getRpcPool() != null && t.getRpcPool().isAlived()).count();
            if (count < (long)this.minResult) {
                rpcBatchResult.isFail(true);
                rpcBatchResult.msg("nodes disconnect");
                return rpcBatchResult;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return rpcBatchResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTaskSize() {
        Map<String, NioTask> map = this.taskList;
        synchronized (map) {
            return this.taskList.size();
        }
    }

    @Override
    public int getMinNodeSize() {
        this.minOnlineNodes = 0;
        this.nodes.forEach((k, v) -> {
            if (v.getStatus() == Node.NodeStatus.METRONOMER) {
                ++this.minOnlineNodes;
            }
        });
        if (this.minOnlineNodes < this.iptables.size()) {
            this.minOnlineNodes = this.iptables.size();
        }
        return PBFT.getMinByCount(this.minOnlineNodes);
    }

    @Override
    public void addNodeToNodes(Node node) {
        if (this.nodes.get(node.getId()) == null) {
            this.nodes.put(node.getId(), node);
        } else {
            Node n = this.nodes.get(node.getId());
            n.setStatus(node.getStatus());
        }
    }

    private void asynGetNodesByIpTable() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Boolean> flag = new HashMap<String, Boolean>();
                Iterator ip_i = NioNet.this.iptables.iterator();
                HashMap<String, NioRpcSynResponseClient> clients = new HashMap<String, NioRpcSynResponseClient>();
                while (ip_i.hasNext()) {
                    String ip = (String)ip_i.next();
                    if (ip == null || ip.length() <= 0) continue;
                    flag.put(ip, false);
                }
                while (NioNet.this.status) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ip) {
                        // empty catch block
                    }
                    Iterator server_i = flag.keySet().iterator();
                    while (server_i.hasNext()) {
                        String server = null;
                        try {
                            Node node;
                            RPCResult<Node> r;
                            server = (String)server_i.next();
                            boolean flag_v = (Boolean)flag.get(server);
                            if (flag_v) continue;
                            NioRpcSynResponseClient client = (NioRpcSynResponseClient)clients.get(server);
                            if (client == null) {
                                client = new NioRpcSynResponseClient(new NioRpcClient(NioNet.this.nioRpcChannelFactory, server, NioNet.this.serverPort, 3000L, NioNet.this.token, NioNet.this.connectionId, NioNet.this.key.getLocalCertBase64String()));
                                if (client.isActive()) {
                                    clients.put(server, client);
                                } else {
                                    client.close();
                                    client = null;
                                    continue;
                                }
                            }
                            RPCMessage requesy_node = new RPCMessage();
                            requesy_node.setTarget(server);
                            requesy_node.setTargetType(RPCMessage.TargetType.REQUEST_NODE);
                            requesy_node.setSender(NioNet.this.connectionId);
                            String r_str = client.sendAndReturn(requesy_node.toJsonString(), 5000L);
                            if (r_str == null || (r = RPCResultJSONObject.parseObject(r_str, Node.class)) == null || r.getEntity() == null || (node = r.getEntity()) == null) continue;
                            if (SoutUtil.isOpenSout()) {
                                System.out.println("\u521d\u6b21\u6536\u5230node=" + node.toJSONString());
                            }
                            NioNet.this.nodes.put(node.getId(), node);
                            client.close();
                            clients.remove(server);
                            flag.put(server, true);
                        }
                        catch (Exception e) {
                            if (SoutUtil.isOpenSout()) {
                                System.out.println("request error server ip=" + server);
                            }
                            e.printStackTrace();
                        }
                    }
                    NioNet.this.true_count = 0;
                    flag.forEach((k, v) -> {
                        if (v.booleanValue()) {
                            NioNet.this.true_count++;
                        }
                    });
                    if (NioNet.this.true_count < NioNet.this.minResult) continue;
                    break;
                }
            }
        }).start();
    }

    @Override
    public List<Node> getNodes() {
        return this.nodes.entrySet().stream().filter(en -> en.getValue() != null).map(en -> (Node)en.getValue()).collect(Collectors.toList());
    }

    @Override
    public void stop() {
        this.status = false;
        this.workGroup.shutdownGracefully();
    }

    public class NioTask {
        private boolean status = true;
        private NioRpcClientPool rpcPool;
        private NioRequest request;
        private NioResphone resphone;

        public NioTask(String serverHost, int serverPort, Cipher cipher, String token, Key key, String connectionId, int workerNum) {
            String serverPublicKey = null;
            try {
                NioRpcClient client = new NioRpcClient(NioNet.this.nioRpcChannelFactory, serverHost, serverPort, 3000L, token, connectionId, key.getLocalCertBase64String());
                serverPublicKey = client.getServerPublicKey();
                NioRpcHeartClient heartClient = new NioRpcHeartClient(client, this);
                this.rpcPool = this.createPool(serverHost, serverPort, token, connectionId, key.getLocalCertBase64String());
                this.rpcPool.setRpcHeartClient(heartClient);
            }
            catch (Exception e) {
                throw new ParameterException("get NioRpcClientPool Exception, target ip=" + serverHost + "  :" + e.getMessage());
            }
            this.request = new NioRequest(this, serverHost, serverPort, cipher, token, key, connectionId, workerNum, serverPublicKey);
            this.resphone = new NioResphone(this, serverHost, connectionId, key, cipher, workerNum, serverPublicKey);
        }

        private NioRpcClientPool createPool(String serverHost, int serverPort, String token, String connId, String publicKey) {
            NioRpcClientPoolConfig config = new NioRpcClientPoolConfig(new NioRpcChannelFactory(NioNet.this.bootstrap), serverHost, serverPort, 5000L, token, connId, publicKey);
            config.setMaxTotal(4);
            config.setMaxIdle(1);
            NioPoolableRpcClientFactory factory = new NioPoolableRpcClientFactory(config, this);
            NioRpcClientPool pool = new NioRpcClientPool(factory, config);
            return pool;
        }

        public void addRequest(RPCMessage msg) {
            if (this.status) {
                this.request.addRequest(msg);
            }
        }

        public RPCResult poll(String messageId) {
            return this.resphone.poll(messageId);
        }

        public boolean isStatus() {
            return this.status;
        }

        public void start() {
            this.status = true;
            this.request.start();
            this.resphone.start();
        }

        public void stop() {
            this.status = false;
            this.request.stop();
            this.resphone.stop();
            this.rpcPool.close();
            if (this.rpcPool.isClosed()) {
                this.rpcPool.clear();
            }
        }

        public NioRpcClient getClient() {
            try {
                return (NioRpcClient)this.rpcPool.borrowObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public <T> T getClient(Class<T> clazz) {
            if (clazz == NioRpcResponseClient.class) {
                NioRpcResponseClient nioRpcResponseClient = new NioRpcResponseClient(this.getClient());
                return (T)nioRpcResponseClient;
            }
            if (clazz == NioRpcSynResponseClient.class) {
                NioRpcSynResponseClient nioResClient = new NioRpcSynResponseClient(this.getClient());
                return (T)nioResClient;
            }
            return (T)this.getClient();
        }

        public void returnClient(NioRpcClient client) {
            this.rpcPool.returnObject(client);
        }

        public void setStatus(boolean status) {
            this.status = status;
        }

        public NioRpcClientPool getRpcPool() {
            return this.rpcPool;
        }

        public void setRpcPool(NioRpcClientPool rpcPool) {
            this.rpcPool = rpcPool;
        }
    }
}

