/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc;

import cn.tdchain.jbcc.Connection;
import org.apache.commons.lang3.StringUtils;

public class ConnectionBuilder {
    private Connection connection;
    private String[] iptables;
    private int port;
    private String token;
    private long timeout;
    private String ksPath;
    private String ksPasswd;

    public Connection getConnection() {
        if (this.connection == null) {
            this.verify();
            this.connection = new Connection(this.iptables, this.port, this.token, this.timeout, this.ksPath, this.ksPasswd);
        }
        return this.connection;
    }

    public static ConnectionBuilder instance() {
        return new ConnectionBuilder();
    }

    public ConnectionBuilder iptables(String[] iptables) {
        this.iptables = iptables;
        return this;
    }

    public ConnectionBuilder port(int port) {
        this.port = port;
        return this;
    }

    public ConnectionBuilder token(String token) {
        this.token = token;
        return this;
    }

    public ConnectionBuilder timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public ConnectionBuilder ksPath(String ksPath) {
        this.ksPath = ksPath;
        return this;
    }

    public ConnectionBuilder ksPasswd(String ksPasswd) {
        this.ksPasswd = ksPasswd;
        return this;
    }

    public void verify() {
        if (this.iptables == null || this.iptables.length == 0) {
            throw new RuntimeException("iptables connfig error, please check iptables ");
        }
        if (this.port < 1025 || this.port > 65534) {
            throw new RuntimeException("port error. [1025~65534] ");
        }
        if (StringUtils.isBlank((CharSequence)this.token)) {
            throw new RuntimeException("token is empty ");
        }
        if (StringUtils.isBlank((CharSequence)this.ksPath)) {
            throw new RuntimeException("keystore path is empty ");
        }
        if (StringUtils.isBlank((CharSequence)this.ksPasswd)) {
            throw new RuntimeException("keystore passwd is empty ");
        }
    }
}

