/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc;

import cn.tdchain.Block;
import cn.tdchain.BlockHead;
import cn.tdchain.ChainTrans;
import cn.tdchain.Trans;
import cn.tdchain.TransHead;
import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.CipherException;
import cn.tdchain.cipher.Key;
import cn.tdchain.cipher.utils.HashCheckUtil;
import cn.tdchain.jbcc.BatchTrans;
import cn.tdchain.jbcc.ConnectionTimeOutException;
import cn.tdchain.jbcc.ManagerTransactionPool;
import cn.tdchain.jbcc.PBFT;
import cn.tdchain.jbcc.ParameterException;
import cn.tdchain.jbcc.Result;
import cn.tdchain.jbcc.SQLCheckUtil;
import cn.tdchain.jbcc.SoutUtil;
import cn.tdchain.jbcc.Transaction;
import cn.tdchain.jbcc.net.Net;
import cn.tdchain.jbcc.net.info.Node;
import cn.tdchain.jbcc.net.nio.NioNet;
import cn.tdchain.jbcc.rpc.RPCBatchResult;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.RPCResult;
import cn.tdchain.tdmsp.Msp;
import cn.tdchain.tdmsp.accessctl.Permission;
import cn.tdchain.tdmsp.accessctl.SystemDefKey;
import cn.tdchain.tdmsp.util.MemberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Connection {
    private int minSucces = 1;
    protected Key key = new Key();
    protected Net net;
    protected String connectionId = UUID.randomUUID().toString();
    protected Cipher cipher = new Cipher();
    protected String account;
    protected String role;
    protected static final ScheduledExecutorService scheduledService = Executors.newSingleThreadScheduledExecutor();

    public Result<TransHead> addTrans(Trans trans) {
        if (trans == null) {
            return new Result<TransHead>("trans is null");
        }
        BatchTrans<Trans> batch = new BatchTrans<Trans>();
        batch.setConnectionId(this.connectionId);
        batch.addTransToBatch(trans);
        Result<BatchTrans<TransHead>> rpcResult = this.addBatchTrans(batch);
        Result<TransHead> result = new Result<TransHead>();
        result.setStatus(rpcResult.getStatus());
        result.setMsg(rpcResult.getMsg());
        if (!rpcResult.isSuccess()) {
            return result;
        }
        BatchTrans<TransHead> batchTrans = rpcResult.getEntity();
        result.setEntity(batchTrans.oneTrans());
        return result;
    }

    public Result<TransHead> addPermissionTrans(Permission permission) {
        if (permission == null) {
            return new Result<TransHead>("permission is null");
        }
        ChainTrans trans = new ChainTrans();
        permission.setSender(this.getAccount());
        trans.setKey(SystemDefKey.SYS_MEMBER_ACL_TACTIC_CTR.name());
        String data = JSON.toJSONString((Object)permission);
        trans.setData(data);
        return this.addTrans(trans);
    }

    public Result<Trans> getPermissionTrans() {
        return this.getNewSystemTransByKey(SystemDefKey.SYS_MEMBER_ACL_TACTIC_CTR.name());
    }

    public Result<Trans> getNewSystemTransByKey(String key) {
        Result<Trans> result = new Result<Trans>();
        if (StringUtils.isBlank((CharSequence)key)) {
            result.setMsg("key is blank");
            return result;
        }
        if (SQLCheckUtil.checkSQLError(key = key.trim())) {
            result.setMsg("key is invalid");
            return result;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("key", key);
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_SYSTEM_TRANS_KEY);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 5000L);
        return batchResult.getResult(new TypeReference<Trans>(){});
    }

    public Result<BatchTrans<TransHead>> addBatchTrans(BatchTrans<Trans> batch) {
        if (batch == null || CollectionUtils.isEmpty(batch.getTransSet())) {
            return new Result<BatchTrans<TransHead>>("batch is empty ");
        }
        batch.setConnectionId(this.connectionId);
        batch.setAccount(this.account);
        HashSet<Trans> transSet = batch.getTransSet();
        for (Trans trans : transSet) {
            trans.setAccount(this.account);
            trans.upHash();
        }
        batch.check();
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(batch.getId());
        msg.setMsg(batch.toJsonString());
        msg.setTargetType(RPCMessage.TargetType.TX_WAIT);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 12000L);
        return batchResult.getResult(new TypeReference<BatchTrans<TransHead>>(){});
    }

    public Result<Block<Trans>> getBlock(long height) {
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("height", String.valueOf(height));
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_BLOCK);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 10000L);
        return batchResult.getResult(new TypeReference<Block<Trans>>(){});
    }

    public Result<BlockHead> getBlockHead(long height) {
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("height", String.valueOf(height));
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setCommand(command);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setTargetType(RPCMessage.TargetType.GET_BLOCK_HEADER);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 10000L);
        return batchResult.getResult(new TypeReference<BlockHead>(){});
    }

    public Result<List<BlockHead>> getBlockHeadList(long startHeight, long endHeight) {
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("startHeight", String.valueOf(startHeight));
        command.put("endHeight", String.valueOf(endHeight));
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_BLOCK_HEADERS);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 10000L);
        return batchResult.getResult(new TypeReference<List<BlockHead>>(){});
    }

    public Result<BlockHead> getMaxBlockHead() {
        return this.getBlockHead(-1L);
    }

    public Result<Block<Trans>> getMaxBlock() {
        return this.getBlock(-1L);
    }

    public Result<Trans> getTransByHash(String hash) {
        Result<Trans> result = new Result<Trans>();
        if (!HashCheckUtil.hashCheck(hash) || hash.length() <= 64) {
            result.setMsg("invalid param");
            result.setStatus(RPCResult.StatusType.fail);
            return result;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("hash", hash);
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_HASH);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 3000L);
        return batchResult.getResult(new TypeReference<Trans>(){});
    }

    public Result<List<Trans>> getTransListByHashList(List<String> hashList) {
        Result<List<Trans>> result = new Result<List<Trans>>();
        if (CollectionUtils.isEmpty(hashList)) {
            result.setMsg("invalid param");
            return result;
        }
        if (hashList.size() > 100) {
            result.setMsg("hashList is too large [ less than or equal to  MAX_TRANS_COUNT ]");
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("hashList", JSONObject.toJSONString(hashList));
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_LIST);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 6000L);
        return batchResult.getResult(new TypeReference<List<Trans>>(){});
    }

    public Result<Trans> getNewTransByKey(String key) {
        Result<Trans> result = new Result<Trans>();
        if (StringUtils.isBlank((CharSequence)key)) {
            result.setMsg("key is blank");
            return result;
        }
        if (SQLCheckUtil.checkSQLError(key = key.trim())) {
            result.setMsg("key is invalid");
            return result;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("key", key);
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_KEY);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 3000L);
        return batchResult.getResult(new TypeReference<Trans>(){});
    }

    public Result<List<Trans>> getTransListByType(String type) {
        Result<List<Trans>> result = new Result<List<Trans>>();
        if (StringUtils.isBlank((CharSequence)type)) {
            result.setMsg("type is blank");
            return result;
        }
        if (HashCheckUtil.illegalCharacterCheck(type) || type == null || type.length() > 45) {
            result.setMsg("type have Illegal character or length too long.");
            return result;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("type", type);
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_LIST_BY_TYPE);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 6000L);
        return batchResult.getResult(new TypeReference<List<Trans>>(){});
    }

    public Result<List<Trans>> getTransHistoryByAccountAndKey(String account, String key, int startIndex, int endIndex) {
        Result<List<Trans>> result = new Result<List<Trans>>();
        if (StringUtils.isBlank((CharSequence)account)) {
            result.setMsg("account is blank");
            return result;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            result.setMsg("key is blank");
            return result;
        }
        if (SQLCheckUtil.checkSQLError(key)) {
            result.setMsg("key is sql limit");
            return result;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("account", account);
        command.put("key", key);
        command.put("startIndex", String.valueOf(startIndex));
        command.put("endIndex", String.valueOf(endIndex));
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_ACCOUNT_KEY_TRANS_HISTORY);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 8000L);
        return batchResult.getResult(new TypeReference<List<Trans>>(){});
    }

    public Result<List<Trans>> getTransHistoryByKey(String key, int startIndex, int endIndex) {
        Result<List<Trans>> result = new Result<List<Trans>>();
        if (StringUtils.isBlank((CharSequence)key)) {
            result.setMsg("key is blank");
            return result;
        }
        if (startIndex < 0 || startIndex > endIndex || endIndex - startIndex >= 29) {
            result.setMsg("startIndex or endIndex error ;endIndex - startIndex not >=29");
            return result;
        }
        if (SQLCheckUtil.checkSQLError(key)) {
            result.setMsg("key is sql limit");
            return result;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("key", key);
        command.put("startIndex", startIndex + "");
        command.put("endIndex", endIndex + "");
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(command);
        msg.setTargetType(RPCMessage.TargetType.GET_TRANS_HISTORY);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 8000L);
        return batchResult.getResult(new TypeReference<List<Trans>>(){});
    }

    public Result<Integer> getConnectionCount() {
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setTargetType(RPCMessage.TargetType.GET_CONNECTION_COUNT);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 8000L);
        return batchResult.getResult(new TypeReference<Integer>(){});
    }

    public boolean startTransaction(String[] keys) {
        if (keys != null && keys.length > 0) {
            Transaction transaction = new Transaction(keys);
            return ManagerTransactionPool.register(transaction, 6000L);
        }
        return false;
    }

    public void stopTransaction(String[] keys) {
        if (keys != null && keys.length > 0) {
            Transaction transaction = new Transaction(keys);
            ManagerTransactionPool.destroy(transaction);
        }
    }

    public Result<Long> getBlockChainTransCount() {
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setTargetType(RPCMessage.TargetType.GET_TOTAL_TRANS_COUNT);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 5000L);
        return batchResult.getResult(new TypeReference<Long>(){});
    }

    public Result<Trans> getNewTransByAccountAndKey(String account, String key) {
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.getCommand().put("account", account);
        msg.getCommand().put("key", key);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setTargetType(RPCMessage.TargetType.GET_ACCOUNT_KEY_TRANS);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 5000L);
        return batchResult.getResult(new TypeReference<Trans>(){});
    }

    public List<Node> getBlockChainNodeList() {
        List<Node> nodes = this.net.getNodes();
        return nodes;
    }

    public Result<List<TransHead>> getNewTransListByAccount(String account) {
        if (account == null) {
            return new Result<List<TransHead>>("account is null");
        }
        RPCMessage msg = new RPCMessage(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setTargetType(RPCMessage.TargetType.GET_NEW_TRANS_LIST);
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("account", account);
        msg.setCommand(command);
        this.net.request(msg);
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 5000L);
        return batchResult.getResult(new TypeReference<List<TransHead>>(){});
    }

    public String getId() {
        return this.connectionId;
    }

    protected Connection(String[] ipArr, int port, String token, String ksPath, String ksPasswd) {
        this(ipArr, port, token, 3000L, ksPath, ksPasswd);
    }

    protected Connection(String[] ipTable, int port, Key key, String token, Cipher cipher) {
        this.key = key;
        this.cipher = cipher;
        this.minSucces = PBFT.getMinByCount(ipTable.length);
        this.role = MemberUtil.generateRole(key);
        this.account = MemberUtil.generateAccount(key);
        this.openNet(ipTable, port, token, cipher);
        this.asynAskNodes(3000L);
    }

    protected Connection(String[] ipArr, int port, String token, long timeout, String ksPath, String ksPasswd) {
        this.minSucces = PBFT.getMinByCount(ipArr.length);
        this.readyCert(ksPath, ksPasswd);
        this.openNet(ipArr, port, token);
        this.asynAskNodes(timeout);
    }

    protected void openNet(String[] ipArr, int port, String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ParameterException("token is empty ");
        }
        this.net = new NioNet(ipArr, port, this.cipher, token, this.key, this.connectionId);
        this.net.start();
        Long start = System.currentTimeMillis();
        while (this.net.getTaskSize() < this.net.getMinNodeSize()) {
            if (System.currentTimeMillis() - start >= 20000L) {
                this.net.stop();
                throw new ConnectionTimeOutException("Connection time out, iptables=" + StringUtils.join((Object[])ipArr, (String)", ") + ",port=" + port + ",token=" + token);
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void openNet(String[] ipArr, int port, String token, Cipher cipher) {
        this.cipher = cipher;
        this.openNet(ipArr, port, token);
    }

    protected void asynAskNodes(long timeout) {
        scheduledService.scheduleAtFixedRate(() -> {
            try {
                RPCMessage msg = new RPCMessage(this.connectionId);
                msg.setTargetType(RPCMessage.TargetType.GET_NODE_LIST);
                msg.setMessageId(UUID.randomUUID().toString());
                this.net.request(msg);
                List<Object> nodes = new ArrayList();
                RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), timeout);
                if (batchResult.isFail()) {
                    batchResult.getResult();
                    return;
                }
                List<Result<List<Node>>> rpcResultList = batchResult.buildList(new TypeReference<List<Node>>(){});
                for (Result<List<Node>> result : rpcResultList) {
                    List<Node> nodeList = result.getEntity();
                    if (nodeList == null || nodeList.size() <= 0 || nodeList.size() <= nodes.size()) continue;
                    nodes = nodeList;
                }
                if (nodes != null && nodes.size() > 0) {
                    for (Node node : nodes) {
                        if (SoutUtil.isOpenSout()) {
                            System.out.println("copy node id:" + node.getId() + " status=" + (Object)((Object)node.getStatus()));
                        }
                        this.net.addNodeToNodes(node);
                    }
                }
                Thread.sleep(1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, 0L, 3L, TimeUnit.SECONDS);
    }

    protected void readyCert(String ksPath, String ksPasswd) {
        try {
            String alias = Msp.ORGANIZATION_ALIAS;
            KeyStore keyStore = Msp.getKeyStore(ksPath, ksPasswd);
            String privateKey = this.cipher.getPrivateKeyStringByKeyStore(keyStore, ksPasswd, alias);
            String publicKey = this.cipher.getPublicKeyStringByStore(keyStore, ksPasswd, alias);
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            String certBase64String = Msp.certToBase64String(cert);
            this.key.setPrivateKey(privateKey);
            this.key.setPublicKey(publicKey);
            this.key.setLocalCertBase64String(certBase64String);
            this.role = MemberUtil.generateRole(this.key);
            this.account = MemberUtil.generateAccount(this.key);
        }
        catch (Exception e) {
            throw new CipherException("get private key by key store error:" + e.getMessage());
        }
    }

    public String getAccount() {
        return this.account;
    }

    public String getRole() {
        return this.role;
    }
}

