/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc;

import cn.tdchain.TransHead;
import cn.tdchain.jbcc.BatchTransException;
import cn.tdchain.jbcc.DateUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class BatchTrans<T extends TransHead> {
    private String account;
    private int index = 1;
    private String id = null;
    private String connectionId;
    private Long timeStamp;
    private HashSet<String> keySet = new HashSet();
    private HashSet<T> transSet = new HashSet();

    public BatchTrans() {
        this.timeStamp = System.currentTimeMillis();
        this.id = UUID.randomUUID().toString();
    }

    public void addTransToBatch(T t) {
        if (t == null) {
            return;
        }
        if (((TransHead)t).getTimestamp() == null) {
            ((TransHead)t).setTimestamp(DateUtils.getCurrentTime());
        }
        ((TransHead)t).check();
        if (this.keySet.contains(((TransHead)t).getKey()) || this.transSet.contains(t)) {
            throw new BatchTransException("batch trans exist key:" + ((TransHead)t).getKey());
        }
        this.transSet.add(t);
        this.keySet.add(((TransHead)t).getKey());
    }

    public void addTransToBatch(List<T> transList) {
        if (transList == null || transList.size() == 0) {
            throw new BatchTransException("batch trans is empty");
        }
        if (transList.size() > 100) {
            throw new BatchTransException("trans of current batch is too large [ less than or equal to 100 ] ");
        }
        for (TransHead trans : transList) {
            this.addTransToBatch(trans);
        }
    }

    public List<String> hashListfromBatch() {
        ArrayList<String> hashList = new ArrayList<String>(this.keySet.size() + 3);
        for (TransHead t : this.transSet) {
            if (t == null) continue;
            hashList.add(t.getHash());
        }
        return hashList;
    }

    public int sizeFromBatch() {
        return this.transSet.size();
    }

    public boolean isExistKeys(HashSet keySet) {
        return this.keySet.contains(keySet);
    }

    public void check() {
        this.check(false);
    }

    public void check(boolean enableVerifySensitiveWorks) {
        if (this.sizeFromBatch() == 0) {
            throw new BatchTransException("batch size is zero");
        }
        if (this.transSet.size() > 100) {
            throw new BatchTransException("trans of current batch is too large [ less than or equal to 100 ] ");
        }
        HashSet<String> t_keySet = new HashSet<String>();
        for (TransHead t : this.transSet) {
            if (t == null) {
                throw new BatchTransException("trans is null");
            }
            t.check(enableVerifySensitiveWorks);
            if (t_keySet.contains(t.getKey())) {
                throw new BatchTransException("repeated key:" + t.getKey());
            }
            t_keySet.add(t.getKey());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HashSet<String> getKeySet() {
        return this.keySet;
    }

    public void setKeySet(HashSet<String> keySet) {
        this.keySet = keySet;
    }

    public HashSet<T> getTransSet() {
        return this.transSet;
    }

    public void setTransSet(HashSet<T> transSet) {
        this.transSet = transSet;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String toJsonString() {
        return JSONObject.toJSONString((Object)this);
    }

    public Long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public TransHead oneTrans() {
        Iterator<T> iterator = this.transSet.iterator();
        if (iterator.hasNext()) {
            TransHead t = (TransHead)iterator.next();
            return t;
        }
        return null;
    }

    public String[] keyToArray() {
        String[] keys = new String[this.keySet.size()];
        this.keySet.toArray(keys);
        return keys;
    }
}

