/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.utils;

import java.math.BigInteger;

public final class ByteUtils {
    private ByteUtils() {
    }

    public static String byteToHex(byte[] value) {
        if (value == null) {
            return null;
        }
        String hs = "";
        String stmp = "";
        for (int n = 0; n < value.length; ++n) {
            stmp = Integer.toHexString(value[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs;
    }

    public static byte[] toBytesPadded(BigInteger value, int length) {
        int srcOffset;
        int bytesLength;
        byte[] result = new byte[length];
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            bytesLength = bytes.length - 1;
            srcOffset = 1;
        } else {
            bytesLength = bytes.length;
            srcOffset = 0;
        }
        if (bytesLength > length) {
            throw new RuntimeException("Input is too large to put in byte array of size " + length);
        }
        int destOffset = length - bytesLength;
        System.arraycopy(bytes, srcOffset, result, destOffset, bytesLength);
        return result;
    }
}

