/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.sm;

import cn.tdchain.cipher.utils.ByteUtils;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Sm3Util {
    public static String hash(String text) {
        byte[] srcData = text.getBytes(StandardCharsets.UTF_8);
        SM3Digest digest = new SM3Digest();
        digest.update(srcData, 0, srcData.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return ByteUtils.byteToHex(hash);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

