/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.cuda.client;

import cn.tdchain.cipher.cuda.client.TDRpcClient;
import cn.tdchain.cipher.cuda.client.TDRpcClientPool;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CUDACipherClient {
    private long WAIT_TIME = 1000L;
    private String null_str = "null";
    private String padingChar = "0";
    private int blockSize = 16;
    private TDRpcClientPool pool = null;
    private ConcurrentLinkedQueue<String> dataQueue = new ConcurrentLinkedQueue();
    private HashMap<String, String> resultMap = new HashMap();

    public CUDACipherClient(String server, int port, int maxPoolSize) throws IOException {
        this.pool = new TDRpcClientPool(server, port, maxPoolSize);
        for (int i = 0; i < maxPoolSize; ++i) {
            this.asynRsaDecrypt();
        }
    }

    private void asynRsaDecrypt() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            String data;
                            boolean isFlag = false;
                            StringBuilder sb = new StringBuilder();
                            while ((data = (String)CUDACipherClient.this.dataQueue.poll()) != null) {
                                sb.append(data + ",");
                                isFlag = true;
                            }
                            String value = CUDACipherClient.this.null_str;
                            if (isFlag) {
                                sb.replace(sb.length() - 1, sb.length(), "");
                                TDRpcClient client = CUDACipherClient.this.pool.getClient();
                                if (client == null) {
                                    throw new RuntimeException(" TDRpcClient is null.");
                                }
                                value = client.request("RSA_DECRYPT@" + sb.toString());
                                CUDACipherClient.this.pool.returnClient(client);
                            }
                            if (!CUDACipherClient.this.null_str.equals(value)) {
                                String[] nodes = value.split(",");
                                for (int i = 0; nodes != null && i < nodes.length; ++i) {
                                    String node = nodes[i];
                                    String[] blockes = node.split(";");
                                    String id = blockes[0];
                                    String data2 = blockes[1];
                                    CUDACipherClient.this.resultMap.put(id, data2);
                                }
                            }
                            Thread.sleep(3L);
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public String aes_encrypt(String text, String passwd) {
        TDRpcClient client = this.pool.getClient();
        if (client == null) {
            return null;
        }
        try {
            int num = text.getBytes("UTF-8").length % this.blockSize;
            if (num > 0) {
                StringBuilder sb = new StringBuilder(text);
                int n = this.blockSize - num;
                for (int i = 0; i < n; ++i) {
                    sb.append(this.padingChar);
                }
                text = sb.toString();
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String value = client.request("AES_ENCRYPT@" + text + "@" + passwd);
        this.pool.returnClient(client);
        return value;
    }

    public String aes_decrypt(String cipherText, String passwd) {
        TDRpcClient client = this.pool.getClient();
        if (client == null) {
            return null;
        }
        String value = client.request("AES_DECRYPT@" + cipherText + "@" + passwd);
        this.pool.returnClient(client);
        if (value != null && value.matches(".+0+")) {
            value = value.replaceAll("0+$", "");
        }
        return value;
    }

    public String hash_256(String text) {
        TDRpcClient client = this.pool.getClient();
        if (client == null) {
            return null;
        }
        String value = client.request("SHASH@" + text);
        this.pool.returnClient(client);
        return value;
    }

    public String rsa_decrypt(String cipherText, String privateKey) {
        String id = UUID.randomUUID().toString();
        StringBuilder sb = new StringBuilder();
        sb.append(id).append(";").append(cipherText).append(";").append(privateKey);
        this.dataQueue.add(sb.toString());
        String value = null;
        long start = System.currentTimeMillis();
        try {
            while (System.currentTimeMillis() - start <= this.WAIT_TIME && (value = this.resultMap.remove(id)) == null) {
                Thread.sleep(3L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value;
    }
}

