/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.tdmsp.util;

import cn.tdchain.tdmsp.ca.config.KeyStoreParam;
import cn.tdchain.tdmsp.util.IOUtils;
import cn.tdchain.tdmsp.util.SecureRandomUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.Calendar;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public final class PkiUtil {
    private PkiUtil() {
    }

    public static KeyPair generateRsaKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        kpGen.initialize(1024, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair generateSm2KeyPair() throws Exception {
        KeyPairGenerator g = KeyPairGenerator.getInstance("EC", "BC");
        g.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("sm2p256v1"), new SecureRandom());
        return g.generateKeyPair();
    }

    public static KeyPair generateEccKeyPair() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec("secp256k1");
        keyPairGenerator.initialize(ecGenParameterSpec, SecureRandomUtils.secureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    public static KeyPair generateEcEncryptKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)ECNamedCurveTable.getParameterSpec((String)"secp256k1"));
        return keyPairGenerator.generateKeyPair();
    }

    public static X500Name getNameBuilder(String name, String company, String country) {
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        nameBuilder.addRDN(BCStyle.CN, name);
        nameBuilder.addRDN(BCStyle.O, company);
        nameBuilder.addRDN(BCStyle.C, country);
        return nameBuilder.build();
    }

    public static X500Name getOuNameBuilder(String name, String company, String country) {
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        nameBuilder.addRDN(BCStyle.CN, name);
        nameBuilder.addRDN(BCStyle.OU, company);
        nameBuilder.addRDN(BCStyle.C, country);
        return nameBuilder.build();
    }

    public static byte[] getRootEncodedHolder(SubjectPublicKeyInfo subPubKeyInfo, X500Name x500Name, int validTime, X500Name subject, PrivateKey privateKey, String algorithm) throws Exception {
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        Calendar c = Calendar.getInstance();
        Date startDate = c.getTime();
        c.add(1, validTime);
        Date endDate = c.getTime();
        X509v3CertificateBuilder x509v3CertBuilder = new X509v3CertificateBuilder(x500Name, serialNumber, startDate, endDate, subject, subPubKeyInfo);
        BasicConstraints constraints = new BasicConstraints(true);
        x509v3CertBuilder.addExtension(Extension.basicConstraints, true, constraints.getEncoded());
        KeyUsage usage = new KeyUsage(166);
        x509v3CertBuilder.addExtension(Extension.keyUsage, true, usage.getEncoded());
        x509v3CertBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.anyExtendedKeyUsage));
        DigestCalculator calculator = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        X509ExtensionUtils extensionUtils = new X509ExtensionUtils(calculator);
        x509v3CertBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extensionUtils.createSubjectKeyIdentifier(subPubKeyInfo));
        X509CertificateHolder holder = x509v3CertBuilder.build(PkiUtil.getSigner(privateKey, algorithm));
        return holder.getEncoded();
    }

    public static byte[] getEncodedHolder(SubjectPublicKeyInfo subPubKeyInfo, X500Name x500Name, int validTime, X500Name subject, PrivateKey privateKey, String algorithm, PublicKey rootPublickey) throws Exception {
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        Calendar c = Calendar.getInstance();
        Date startDate = c.getTime();
        c.add(1, validTime);
        Date endDate = c.getTime();
        X509v3CertificateBuilder x509v3CertBuilder = new X509v3CertificateBuilder(x500Name, serialNumber, startDate, endDate, subject, subPubKeyInfo);
        BasicConstraints constraints = new BasicConstraints(false);
        x509v3CertBuilder.addExtension(Extension.basicConstraints, true, constraints.getEncoded());
        KeyUsage usage = new KeyUsage(144);
        x509v3CertBuilder.addExtension(Extension.keyUsage, true, usage.getEncoded());
        DigestCalculator calculator = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        X509ExtensionUtils extensionUtils = new X509ExtensionUtils(calculator);
        SubjectPublicKeyInfo rootPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)rootPublickey.getEncoded());
        x509v3CertBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extensionUtils.createAuthorityKeyIdentifier(rootPubKeyInfo));
        X509CertificateHolder holder = x509v3CertBuilder.build(PkiUtil.getSigner(privateKey, algorithm));
        return holder.getEncoded();
    }

    public static PKCS10CertificationRequest generateEnrollRequest(KeyPair keyPair, String algorithm, String name, String company, String country) throws Exception {
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(PkiUtil.getNameBuilder(name, company, country), keyPair.getPublic());
        return p10Builder.build(PkiUtil.getSigner(keyPair.getPrivate(), algorithm));
    }

    public static PKCS10CertificationRequest generateEccEncryptEnrollCARequest(KeyPair keyPair, String country, String company, String name) throws Exception {
        PKCS10CertificationRequest csr = null;
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        nameBuilder.addRDN(BCStyle.CN, country);
        nameBuilder.addRDN(BCStyle.O, company);
        nameBuilder.addRDN(BCStyle.C, name);
        X500Name x500Name = nameBuilder.build();
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(x500Name, keyPair.getPublic());
        p10Builder.addAttribute(new ASN1ObjectIdentifier("1.2.840.10045.2.1"), (ASN1Encodable)new DERGeneralString("EC"));
        JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder("SHA256withECDSA");
        ContentSigner signer = csBuilder.build(keyPair.getPrivate());
        csr = p10Builder.build(signer);
        return csr;
    }

    public static ContentSigner getSigner(PrivateKey privateKey, String algorithm) throws OperatorCreationException {
        JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder(algorithm).setProvider("BC");
        ContentSigner signer = csBuilder.build(privateKey);
        return signer;
    }

    public static void saveToKeystore(KeyStoreParam param, PrivateKey privateKey, String keyStoreType) throws Exception {
        File storeFile;
        KeyStore store = null;
        store = "PKCS12".equals(keyStoreType) ? KeyStore.getInstance("PKCS12", "BC") : KeyStore.getInstance("JCEKS");
        store.load(null, null);
        Certificate[] chain = param.getChain();
        store.setCertificateEntry(param.getCertAlias(), chain[0]);
        if (chain.length > 1 && null != param.getRootAlias()) {
            store.setCertificateEntry(param.getRootAlias(), chain[1]);
        }
        store.setKeyEntry(param.getPrivateKeyAlias(), privateKey, param.getPrivateKeyPassword().toCharArray(), chain);
        File storeDir = new File(param.getPath());
        if (!storeDir.exists()) {
            storeDir.mkdirs();
        }
        if (!(storeFile = new File(param.getKsFilePath())).exists()) {
            storeFile.createNewFile();
            try (FileOutputStream fos = new FileOutputStream(storeFile);){
                store.store(fos, param.getKsPassword().toCharArray());
            }
            if (chain.length == 1) {
                PkiUtil.saveCertToFile(param.getPath() + "rootCert.cer", (X509Certificate)chain[0]);
            }
            if (chain.length > 1) {
                PkiUtil.saveCertToFile(param.getPath() + "ouCert.cer", (X509Certificate)chain[0]);
                PkiUtil.saveCertToFile(param.getPath() + "rootCert.cer", (X509Certificate)chain[1]);
            }
        }
    }

    public static KeyStore getKeyStore(String filePath, String ksPassword, String keyStoreType) throws Exception {
        KeyStore store = null;
        File storeFile = new File(filePath);
        if (!storeFile.exists()) {
            return null;
        }
        try (FileInputStream fileInputStream = new FileInputStream(filePath);){
            store = "JCEKS".equals(keyStoreType) ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(keyStoreType, "BC");
            store.load(fileInputStream, ksPassword.toCharArray());
            KeyStore keyStore = store;
            return keyStore;
        }
    }

    public static void saveCertToFile(String fileName, X509Certificate cert) {
        try {
            File file = new File(fileName);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(cert.getEncoded());
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static X509Certificate getCertFromCer(String filePath) {
        X509Certificate cert = null;
        byte[] certByte = IOUtils.getBytes(filePath);
        ByteArrayInputStream inStream = new ByteArrayInputStream(certByte);
        try {
            cert = (X509Certificate)CertificateFactory.getInstance("X509", "BC").generateCertificate(inStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cert;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

