/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.tdmsp.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;

public class LinuxSecureRandom
extends SecureRandomSpi {
    private static final long serialVersionUID = 208702708372565523L;
    private static final FileInputStream RANDOM;
    private final DataInputStream dis = new DataInputStream(RANDOM);

    @Override
    protected void engineSetSeed(byte[] bytes) {
    }

    @Override
    protected void engineNextBytes(byte[] bytes) {
        try {
            this.dis.readFully(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected byte[] engineGenerateSeed(int i) {
        byte[] bits = new byte[i];
        this.engineNextBytes(bits);
        return bits;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        try {
            File file = new File("/dev/urandom");
            RANDOM = new FileInputStream(file);
            if (RANDOM.read() == -1) {
                throw new RuntimeException("/dev/urandom not readable?");
            }
            int position = Security.insertProviderAt(new LinuxSecureRandomProvider(), 1);
            if (position == -1) return;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class LinuxSecureRandomProvider
    extends Provider {
        private static final long serialVersionUID = -432355574793128305L;

        LinuxSecureRandomProvider() {
            super("LinuxSecureRandom", 1.0, "A Linux specific random number provider that uses /dev/urandom");
            this.put("SecureRandom.LinuxSecureRandom", LinuxSecureRandom.class.getName());
        }
    }
}

