/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.tdmsp.util;

import cn.tdchain.cipher.utils.StringUtils;
import cn.tdchain.tdmsp.util.SecureRandomUtils;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;

public final class EccUtil {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static Signature signature;
    private static ThreadLocal<Cipher> cipherThreadLocal;

    private EccUtil() {
    }

    public static String encrypt(String data, ECPublicKey ecPublicKey) {
        if (StringUtils.isBlank(data) || ecPublicKey == null) {
            return data;
        }
        try {
            Cipher cipher = EccUtil.getCipher(ecPublicKey, 1);
            byte[] encryptedData = cipher.doFinal(data.getBytes(UTF8));
            return Base64.getEncoder().encodeToString(encryptedData);
        }
        catch (Exception exception) {
            return data;
        }
    }

    public static ECPublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String[] strbyte = publicKey.split("@");
        String xstr = strbyte[0];
        String ystr = strbyte[1];
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        ECPoint ecPoint = new ECPoint(new BigInteger(1, Base64.getDecoder().decode(xstr)), new BigInteger(1, Base64.getDecoder().decode(ystr)));
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        ECNamedCurveSpec spec = new ECNamedCurveSpec("secp256k1", parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH(), parameterSpec.getSeed());
        ECPublicKey ecPublicKey = (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec(ecPoint, (ECParameterSpec)spec));
        return ecPublicKey;
    }

    public static String decrypt(String data, ECPrivateKey privateKey) {
        if (privateKey == null || StringUtils.isBlank(data)) {
            return data;
        }
        try {
            byte[] encryptedData = Base64.getDecoder().decode(data);
            Cipher cipher = EccUtil.getCipher(privateKey, 2);
            byte[] decryptedData = cipher.doFinal(encryptedData);
            return Base64.getEncoder().encodeToString(decryptedData);
        }
        catch (Exception exception) {
            return data;
        }
    }

    public static ECPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey));
        ECPrivateKey newprivateKey = (ECPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        return newprivateKey;
    }

    public static KeyPair createEcKeyPair() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec("secp256k1");
        keyPairGenerator.initialize(ecGenParameterSpec, SecureRandomUtils.secureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    public static String sign(String input, PrivateKey privateKey) {
        if (StringUtils.isBlank(input)) {
            throw new RuntimeException("msg is null");
        }
        if (null == privateKey) {
            throw new RuntimeException("privateKey is null");
        }
        byte[] message = input.getBytes(UTF8);
        String signMsg = "";
        try {
            Signature signature = EccUtil.getSignature();
            signature.initSign(privateKey);
            signature.update(message);
            byte[] res = signature.sign();
            signMsg = Base64.getEncoder().encodeToString(res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return signMsg;
    }

    private static Signature getSignature() {
        if (null != signature) {
            return signature;
        }
        try {
            signature = Signature.getInstance("SHA256withECDSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return signature;
    }

    public static boolean verify(String data, String signMsg, PublicKey publicKey) {
        byte[] message = data.getBytes(UTF8);
        boolean result = false;
        try {
            Signature signature = EccUtil.getSignature();
            signature.initVerify(publicKey);
            signature.update(message);
            result = signature.verify(Base64.getDecoder().decode(signMsg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static Cipher getCipher(Key key, int mode) throws Exception {
        Cipher cipher = cipherThreadLocal.get();
        if (cipher == null) {
            cipher = Cipher.getInstance("ECIES", "BC");
            cipherThreadLocal.set(cipher);
        }
        cipher.init(mode, key);
        return cipher;
    }

    static {
        cipherThreadLocal = new ThreadLocal();
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

