/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.io.eclc;

import cn.tdchain.cipher.rsa.AesUtil;
import cn.tdchain.jbcc.rpc.io.eclc.EclcException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.UUID;

public class EclcSocket
extends Socket {
    private int timeOut = 5000;
    private String serverPublicKey = null;
    private String clientPubliKey = null;

    public EclcSocket(String localPubliKey) {
        this.clientPubliKey = localPubliKey;
    }

    public EclcSocket(InetAddress address, int port, InetAddress localAddr, int localPort, String passwd, String localPubliKey) throws IOException {
        super(address, port, localAddr, localPort);
        this.clientPubliKey = localPubliKey;
        this.eclc(passwd);
    }

    public EclcSocket(InetAddress address, int port, String passwd, String localPubliKey) throws IOException {
        super(address, port);
        this.clientPubliKey = localPubliKey;
        this.eclc(passwd);
    }

    public EclcSocket(String host, int port, InetAddress localAddr, int localPort, String passwd, String localPubliKey) throws IOException {
        super(host, port, localAddr, localPort);
        this.clientPubliKey = localPubliKey;
        this.eclc(passwd);
    }

    public EclcSocket(String host, int port, String passwd, String localPubliKey) throws UnknownHostException, IOException {
        super(host, port);
        this.clientPubliKey = localPubliKey;
        this.eclc(passwd);
    }

    public void connect(SocketAddress endpoint, int timeout, String passwd) throws IOException {
        super.connect(endpoint, timeout);
        this.eclc(passwd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void eclc(String passwd) {
        if (!this.isConnected()) throw new EclcException("EclcServerSocket refuse connection.");
        try {
            this.setSoTimeout(this.timeOut);
            OutputStreamWriter os = new OutputStreamWriter(this.getOutputStream());
            BufferedWriter bwrite = new BufferedWriter(os);
            InputStreamReader ir = new InputStreamReader(this.getInputStream());
            BufferedReader bread = new BufferedReader(ir);
            String data = UUID.randomUUID().toString();
            String data_chi = AesUtil.encrypt(data, passwd);
            bwrite.write(data_chi);
            bwrite.newLine();
            bwrite.flush();
            String result_data = bread.readLine();
            if (result_data == null) throw new EclcException("Eclc  failed! eclc server result null result_data.");
            String[] v_array = result_data.split(";");
            if (v_array == null || v_array.length != 2) throw new EclcException("Eclc  failed! eclc server result null v_array.");
            String s_v_dada = v_array[0];
            String s_dada_chi = v_array[1];
            if (!data.equals(s_v_dada)) throw new EclcException("Eclc  failed! passwd is not agreement.");
            String s_dada = AesUtil.decrypt(s_dada_chi, passwd);
            if (s_dada == null) throw new EclcException("Eclc  failed! passwd is not agreement.");
            bwrite.write(s_dada);
            bwrite.newLine();
            bwrite.flush();
            String p_key = bread.readLine();
            if (p_key != null) {
                this.serverPublicKey = p_key;
            }
            bwrite.write(this.clientPubliKey);
            bwrite.newLine();
            bwrite.flush();
            this.setSoTimeout(0);
            return;
        }
        catch (SocketException e) {
            e.printStackTrace();
            throw new EclcException("EclcServerSocket connection SocketException: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EclcException("EclcServerSocket connection Exception: " + e.getMessage());
        }
    }

    public String getServerPublicKey() {
        return this.serverPublicKey;
    }

    public String getClientPubliKey() {
        return this.clientPubliKey;
    }

    public void setClientPubliKey(String clientPubliKey) {
        this.clientPubliKey = clientPubliKey;
    }

    public void setServerPublicKey(String serverPublicKey) {
        this.serverPublicKey = serverPublicKey;
    }
}

