/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc;

import cn.tdchain.cipher.rsa.Sha256Util;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class MerkleTree {
    public static final int MAGIC_HDR = -844444007;
    public static final int INT_BYTES = 4;
    public static final int LONG_BYTES = 8;
    public static final byte LEAF_SIG_TYPE = 0;
    public static final byte INTERNAL_SIG_TYPE = 1;
    private List<String> leafSigs;
    private BinaryNode root;
    private int depth;
    private int nnodes;

    public MerkleTree(List<String> leafSignatures) {
        this.constructTree(leafSignatures);
    }

    public MerkleTree(BinaryNode treeRoot, int numNodes, int height, List<String> leafSignatures) {
        this.root = treeRoot;
        this.nnodes = numNodes;
        this.depth = height;
        this.leafSigs = leafSignatures;
    }

    public byte[] serialize() {
        int magicHeaderSz = 4;
        int nnodesSz = 4;
        int hdrSz = magicHeaderSz + nnodesSz;
        int typeByteSz = 1;
        int siglength = 4;
        int parentSigSz = 8;
        int leafSigSz = this.leafSigs.get(0).getBytes(StandardCharsets.UTF_8).length;
        int maxSigSz = leafSigSz;
        if (parentSigSz > maxSigSz) {
            maxSigSz = parentSigSz;
        }
        int spaceForNodes = (typeByteSz + siglength + maxSigSz) * this.nnodes;
        int cap = hdrSz + spaceForNodes;
        ByteBuffer buf = ByteBuffer.allocate(cap);
        buf.putInt(-844444007).putInt(this.nnodes);
        this.serializeBreadthFirst(buf);
        byte[] serializedTree = new byte[buf.position()];
        buf.rewind();
        buf.get(serializedTree);
        return serializedTree;
    }

    void serializeBreadthFirst(ByteBuffer buf) {
        ArrayDeque<BinaryNode> q = new ArrayDeque<BinaryNode>(this.nnodes / 2 + 1);
        q.add(this.root);
        while (!q.isEmpty()) {
            BinaryNode nd = (BinaryNode)q.remove();
            buf.put(nd.type).putInt(nd.sig.length).put(nd.sig);
            if (nd.left != null) {
                q.add(nd.left);
            }
            if (nd.right == null) continue;
            q.add(nd.right);
        }
    }

    void constructTree(List<String> signatures) {
        if (signatures.size() <= 1) {
            throw new IllegalArgumentException("Must be at least two signatures to construct a Merkle tree");
        }
        this.leafSigs = signatures;
        this.nnodes = signatures.size();
        List<BinaryNode> parents = this.bottomLevel(signatures);
        this.nnodes += parents.size();
        this.depth = 1;
        while (parents.size() > 1) {
            parents = this.internalLevel(parents);
            ++this.depth;
            this.nnodes += parents.size();
        }
        this.root = parents.get(0);
    }

    public int getNumNodes() {
        return this.nnodes;
    }

    public BinaryNode getRoot() {
        return this.root;
    }

    public int getHeight() {
        return this.depth;
    }

    List<BinaryNode> internalLevel(List<BinaryNode> children) {
        ArrayList<BinaryNode> parents = new ArrayList<BinaryNode>(children.size() / 2);
        for (int i = 0; i < children.size() - 1; i += 2) {
            BinaryNode child1 = children.get(i);
            BinaryNode child2 = children.get(i + 1);
            BinaryNode parent = this.constructInternalNode(child1, child2);
            parents.add(parent);
        }
        if (children.size() % 2 != 0) {
            BinaryNode child = children.get(children.size() - 1);
            BinaryNode parent = this.constructInternalNode(child, null);
            parents.add(parent);
        }
        return parents;
    }

    List<BinaryNode> bottomLevel(List<String> signatures) {
        ArrayList<BinaryNode> parents = new ArrayList<BinaryNode>(signatures.size() / 2);
        for (int i = 0; i < signatures.size() - 1; i += 2) {
            BinaryNode leaf1 = MerkleTree.constructLeafNode(signatures.get(i));
            BinaryNode leaf2 = MerkleTree.constructLeafNode(signatures.get(i + 1));
            BinaryNode parent = this.constructInternalNode(leaf1, leaf2);
            parents.add(parent);
        }
        if (signatures.size() % 2 != 0) {
            BinaryNode leaf = MerkleTree.constructLeafNode(signatures.get(signatures.size() - 1));
            BinaryNode parent = this.constructInternalNode(leaf, null);
            parents.add(parent);
        }
        return parents;
    }

    private BinaryNode constructInternalNode(BinaryNode child1, BinaryNode child2) {
        BinaryNode parent = new BinaryNode();
        parent.type = 1;
        parent.sig = child2 == null ? child1.sig : this.internalHash(child1.sig, child2.sig);
        parent.left = child1;
        parent.right = child2;
        return parent;
    }

    private static BinaryNode constructLeafNode(String signature) {
        BinaryNode leaf = new BinaryNode();
        leaf.type = 0;
        leaf.sig = signature.getBytes(StandardCharsets.UTF_8);
        return leaf;
    }

    private byte[] internalHash(byte[] leftChildSig, byte[] rightChildSig) {
        String leftSign = new String(leftChildSig, StandardCharsets.UTF_8);
        String rightSign = new String(rightChildSig, StandardCharsets.UTF_8);
        return Sha256Util.hash(leftSign + rightSign).getBytes(StandardCharsets.UTF_8);
    }

    public static class BinaryNode {
        public byte type;
        public byte[] sig;
        public BinaryNode left;
        public BinaryNode right;

        public String toString() {
            String leftType = "<null>";
            String rightType = "<null>";
            if (this.left != null) {
                leftType = String.valueOf(this.left.type);
            }
            if (this.right != null) {
                rightType = String.valueOf(this.right.type);
            }
            return String.format("MerkleUtil.BinaryNode<type:%d, sig:%s, left (type): %s, right (type): %s>", this.type, this.getBinaryNodeSig(), leftType, rightType);
        }

        public String getBinaryNodeSig() {
            return new String(this.sig, StandardCharsets.UTF_8);
        }
    }
}

