/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.rsa;

import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.CipherException;
import cn.tdchain.cipher.Key;
import cn.tdchain.cipher.cuda.client.CUDACipherClient;
import cn.tdchain.cipher.rsa.ArrayUtils;
import cn.tdchain.cipher.rsa.RSAKeyStoreUtil;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RsaUtil {
    private static HashMap<String, PublicKey> publicKeyMap = new HashMap();
    private static HashMap<String, PrivateKey> privateKeyMap = new HashMap();
    private static ThreadLocal<javax.crypto.Cipher> cipherThreadLocal = new ThreadLocal();
    private static ThreadLocal<Signature> signatureThreadLocal = new ThreadLocal();
    private static Provider provider = new BouncyCastleProvider();
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static boolean isCuda = false;
    private static CUDACipherClient cuda = null;

    private RsaUtil() {
    }

    public static KeyPair generKey() {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(1024);
            keyPair = keyPairGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CipherException("gener key error: " + e.getMessage());
        }
        return keyPair;
    }

    public static String encrypt(String data, PublicKey key) {
        if (key == null) {
            return data;
        }
        try {
            byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
            byte[] enBytes = null;
            javax.crypto.Cipher cipher = RsaUtil.getCipher(key, 1);
            for (int i = 0; i < dataBytes.length; i += 116) {
                enBytes = ArrayUtils.addAll(enBytes, cipher.doFinal(ArrayUtils.subarray(dataBytes, i, i + 116)));
            }
            return Base64.getEncoder().encodeToString(enBytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getPublicKey(PublicKey publicKey) {
        return Base64.getEncoder().encodeToString(publicKey.getEncoded());
    }

    public static String getPrivateKey(PrivateKey privateKey) {
        return Base64.getEncoder().encodeToString(privateKey.getEncoded());
    }

    public static PublicKey getPublicKey(String publicKeyStr) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PublicKey pubkey = publicKeyMap.get(publicKeyStr);
        if (pubkey == null) {
            byte[] keyBytes = Base64.getDecoder().decode(publicKeyStr);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
            pubkey = keyFactory.generatePublic(keySpec);
            publicKeyMap.put(publicKeyStr, pubkey);
        }
        return pubkey;
    }

    public static String decrypt(String data, java.security.Key key) {
        byte[] enBytes = null;
        if (data == null || data.length() == 0) {
            return null;
        }
        if (key == null) {
            return data;
        }
        byte[] encryptedData = Base64.getDecoder().decode(data);
        try {
            javax.crypto.Cipher cipher = RsaUtil.getCipher(key, 2);
            for (int i = 0; i < encryptedData.length; i += 128) {
                byte[] tmpData = cipher.doFinal(ArrayUtils.subarray(encryptedData, i, i + 128));
                enBytes = ArrayUtils.addAll(enBytes, tmpData);
            }
            return new String(enBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static javax.crypto.Cipher getCipher(java.security.Key key, int mode) throws Exception {
        javax.crypto.Cipher cipher = cipherThreadLocal.get();
        if (cipher == null) {
            cipher = javax.crypto.Cipher.getInstance("RSA/NONE/PKCS1Padding", provider);
            cipherThreadLocal.set(cipher);
        }
        cipher.init(mode, key);
        return cipher;
    }

    public static String sign(PrivateKey privateKey, String text) {
        String signText;
        if (privateKey == null) {
            return text;
        }
        try {
            Signature signature = RsaUtil.getSignature();
            signature.initSign(privateKey);
            signature.update(text.getBytes(StandardCharsets.UTF_8));
            signText = Base64.getEncoder().encodeToString(signature.sign());
        }
        catch (Exception e) {
            signText = null;
        }
        return signText;
    }

    public static boolean verify(PublicKey publicKey, String signText, String text) {
        if (publicKey == null || signText == null || signText.length() == 0 || text == null || text.length() == 0) {
            return false;
        }
        boolean signValue = false;
        try {
            Signature signature = RsaUtil.getSignature();
            signature.initVerify(publicKey);
            signature.update(text.getBytes(StandardCharsets.UTF_8));
            signValue = signature.verify(Base64.getDecoder().decode(signText));
        }
        catch (Exception e) {
            signValue = false;
        }
        return signValue;
    }

    private static Signature getSignature() throws NoSuchAlgorithmException {
        Signature signature = signatureThreadLocal.get();
        if (signature == null) {
            signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signatureThreadLocal.set(signature);
        }
        return signature;
    }

    public static String encrypt(String data, String publicKey) {
        try {
            PublicKey pubKey = RsaUtil.getPublicKey(publicKey);
            return RsaUtil.encrypt(data, pubKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean verify(String publickey, String signature, String data) {
        try {
            PublicKey pubKey = RsaUtil.getPublicKey(publickey);
            return RsaUtil.verify(pubKey, signature, data);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static PrivateKey getPrivateKey(String privateKey) throws Exception {
        PrivateKey privKey = privateKeyMap.get(privateKey);
        if (privKey == null) {
            privKey = RSAKeyStoreUtil.getPrivateKey(privateKey);
            privateKeyMap.put(privateKey, privKey);
        }
        return privKey;
    }

    public static String decrypt(String data, String privateKey) {
        if (isCuda) {
            return cuda.rsa_decrypt(data, privateKey);
        }
        try {
            return RsaUtil.decrypt(data, RsaUtil.getPrivateKey(privateKey));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sign(String privateKeyStr, String data) {
        try {
            return RsaUtil.sign(RsaUtil.getPrivateKey(privateKeyStr), data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            Key key;
            Cipher c;
            String c_text;
            String data_new;
            String data;
            cuda = new CUDACipherClient("192.168.0.9", 8080, 4);
            if (cuda != null && (data = "\u5c0f\u660e\u8001\u5e08").equals(data_new = cuda.rsa_decrypt(c_text = (c = new Cipher()).encryptByPublicKey(data, (key = c.generateKey()).getPublicKey()), key.getPrivateKey()))) {
                isCuda = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

