/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.rsa;

import cn.tdchain.cipher.CipherException;
import cn.tdchain.cipher.utils.CipherUtil;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAKeyStoreUtil {
    private static final String KEY_STORE = "JKS";
    private static final String X509 = "X.509";
    private static Provider provider = new BouncyCastleProvider();

    private RSAKeyStoreUtil() {
    }

    public static String getPrivateKeyString(String path, String alias, String storePass) throws Exception {
        PrivateKey priKey = RSAKeyStoreUtil.getPrivateKey(path, alias, storePass);
        return Base64.getEncoder().encodeToString(priKey.getEncoded());
    }

    public static PrivateKey getPrivateKey(String privateKeyStr) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(privateKeyStr);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
        return keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public static String getPublicKeyStr(String path) throws Exception {
        X509Certificate cert = RSAKeyStoreUtil.getCert(path);
        PublicKey publicKey = cert.getPublicKey();
        return Base64.getEncoder().encodeToString(publicKey.getEncoded());
    }

    public static PublicKey getPublicKey(String publicKeyStr) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(publicKeyStr);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
        return keyFactory.generatePublic(keySpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getCert(String path) throws Exception {
        CertificateFactory certFactory = CertificateFactory.getInstance(X509);
        X509Certificate cert = null;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(path);
            cert = (X509Certificate)certFactory.generateCertificate(fis);
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(String keyStorePath, String password) throws Exception {
        System.out.println("getPublicKeyStringByStore before password: " + password);
        System.out.println("getPublicKeyStringByStore keyStorePath: " + keyStorePath);
        String pwd = CipherUtil.zeroSuffix(password);
        System.out.println("getPublicKeyStringByStore after pwd: " + pwd);
        KeyStore ks = null;
        try (FileInputStream is = null;){
            is = new FileInputStream(keyStorePath);
            ks = KeyStore.getInstance(KEY_STORE);
            ks.load(is, pwd.toCharArray());
        }
        return ks;
    }

    public static void genKey(String path, String password, String alias) {
        File ksPath = new File(path);
        ksPath.getParentFile().mkdirs();
        String pwd = CipherUtil.zeroSuffix(password);
        System.out.println("generateKeyStoreFile path:" + path);
        System.out.println("generateKeyStoreFile pwd:" + pwd);
        String[] arstringCommand = new String[]{"keytool", "-genkey", "-validity", "36500", "-keysize", "1024", "-alias", alias, "-keyalg", "RSA", "-keystore", path, "-dname", RSAKeyStoreUtil.getDname(alias), "-storepass", pwd, "-keypass", pwd, "-v"};
        RSAKeyStoreUtil.execCommand(arstringCommand);
    }

    private static String getDname(String alias) {
        StringBuilder dname = new StringBuilder();
        dname.append("CN=(").append(alias).append("), ");
        dname.append("OU=(").append(alias).append("), ");
        dname.append("O=(").append(alias).append("), ");
        dname.append("L=(BJ), ST=(BJ), C=(CN)");
        return dname.toString();
    }

    public static void genCert(String path, String password, String alias) {
        String pwd = CipherUtil.zeroSuffix(password);
        String[] arstringCommand = new String[]{"keytool", "-export", "-alias", alias, "-keystore", path, "-file", path + ".cert", "-storepass", pwd};
        RSAKeyStoreUtil.execCommand(arstringCommand);
    }

    private static void execCommand(String[] arstringCommand) {
        try {
            Runtime.getRuntime().exec(arstringCommand);
        }
        catch (Exception e) {
            throw new CipherException("exec command error : " + e.getMessage());
        }
    }

    public static PublicKey getPublicKeyByCert(String certPath) throws Exception {
        X509Certificate cert = RSAKeyStoreUtil.getCert(certPath);
        return cert.getPublicKey();
    }

    public static String getPublicKeyStringByKeyStore(String ksPath, String alias, String ksPass) throws Exception {
        PublicKey publicKey = RSAKeyStoreUtil.getPublicKeyByKeyStore(ksPath, alias, ksPass);
        return Base64.getEncoder().encodeToString(publicKey.getEncoded());
    }

    public static PublicKey getPublicKeyByKeyStore(String ksPath, String alias, String ksPass) throws Exception {
        String pwd = CipherUtil.zeroSuffix(ksPass);
        KeyStore ks = RSAKeyStoreUtil.getKeyStore(ksPath, pwd);
        X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
        return cert.getPublicKey();
    }

    public static PrivateKey getPrivateKey(String path, String alias, String storePass) throws Exception {
        String pwd = CipherUtil.zeroSuffix(storePass);
        KeyStore ks = RSAKeyStoreUtil.getKeyStore(path, pwd);
        PrivateKey priKey = (PrivateKey)ks.getKey(alias, pwd.toCharArray());
        return priKey;
    }
}

