/*
 * Decompiled with CFR 0.152.
 */
package cn.tbox.sdk.example;

import cn.tbox.sdk.TboxClient;
import cn.tbox.sdk.core.exception.TboxClientConfigException;
import cn.tbox.sdk.core.exception.TboxHttpResponseException;
import cn.tbox.sdk.model.conversation.Conversation;
import cn.tbox.sdk.model.request.ConversationListRequest;
import cn.tbox.sdk.model.response.ConversationListResponse;
import cn.tbox.sdk.model.response.TboxResponse;
import java.util.List;

public class ConversationListExample {
    public static void main(String[] args) {
        try {
            TboxClient client = new TboxClient("your_authorization_token_here");
            ConversationListRequest basicRequest = new ConversationListRequest("2025*****0812");
            TboxResponse<ConversationListResponse> basicResponse = client.getConversations(basicRequest);
            if (basicResponse.isSuccess()) {
                System.out.println("Basic request successful!");
                List<Conversation> conversations = basicResponse.getData().getConversations();
                for (Conversation conv2 : conversations) {
                    System.out.println("Conversation ID: " + conv2.getConversationId());
                    System.out.println("User ID: " + conv2.getUserId());
                    System.out.println("Source: " + conv2.getSource());
                    System.out.println("Created at: " + conv2.getCreateAt());
                    System.out.println("---");
                }
            } else {
                System.out.println("Request failed: " + basicResponse.getErrorMsg());
            }
            ConversationListRequest advancedRequest = new ConversationListRequest();
            advancedRequest.setAppId("2025*****0812");
            advancedRequest.setUserId("test_user_zs");
            advancedRequest.setSource("AGENT_SDK");
            advancedRequest.setPageNum(1);
            advancedRequest.setPageSize(20);
            advancedRequest.setSortOrder("DESC");
            TboxResponse<ConversationListResponse> advancedResponse = client.getConversations(advancedRequest);
            if (advancedResponse.isSuccess()) {
                System.out.println("Advanced request successful!");
                List<Conversation> conversations = advancedResponse.getData().getConversations();
                System.out.println("Found " + conversations.size() + " conversations");
                conversations.forEach(conv -> System.out.println("Conversation: " + conv.getConversationId()));
            } else {
                System.out.println("Advanced request failed: " + advancedResponse.getErrorMsg());
            }
        }
        catch (TboxClientConfigException e) {
            System.err.println("Configuration error: " + e.getMessage());
        }
        catch (TboxHttpResponseException e) {
            System.err.println("HTTP response error: " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

