/*
 * Decompiled with CFR 0.152.
 */
package cn.tbox.sdk.example;

import cn.tbox.sdk.TboxClient;
import cn.tbox.sdk.core.exception.TboxClientConfigException;
import cn.tbox.sdk.core.exception.TboxHttpResponseException;
import cn.tbox.sdk.model.request.ChatRequest;
import cn.tbox.sdk.model.request.CompletionRequest;
import java.util.HashMap;
import java.util.Map;

public class ChatAndCompletionExample {
    public static void main(String[] args) throws TboxClientConfigException, TboxHttpResponseException {
        try {
            TboxClient client = new TboxClient("your-authorization-token-here");
            System.out.println("Example 1: Simple streaming chat");
            Iterable chatStream = (Iterable)client.chat(new ChatRequest("your-app-id-here", "Hello, how are you?", "user-id-123"));
            for (Map response : chatStream) {
                System.out.println("Received chunk: " + response);
            }
            System.out.println("\nExample 2: Completion with custom inputs");
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            inputs.put("prompt", "Generate a Java function to calculate factorial");
            Iterable completionStream = (Iterable)client.completion(new CompletionRequest("your-app-id-here", "user-id-123", inputs));
            for (Map response : completionStream) {
                System.out.println("Received completion chunk: " + response);
            }
        }
        catch (TboxClientConfigException e) {
            System.err.println("Configuration error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void printResult(Map<String, Map<String, Object>> result) {
        for (Map.Entry<String, Map<String, Object>> entry : result.entrySet()) {
            String lane = entry.getKey();
            Map<String, Object> laneData = entry.getValue();
            System.out.println("Lane: " + lane);
            System.out.println("Type: " + laneData.get("type"));
            System.out.println("Data: " + laneData.get("data"));
        }
    }
}

