/*
 * Decompiled with CFR 0.152.
 */
package cn.tbox.sdk;

import cn.tbox.sdk.core.exception.TboxClientConfigException;
import cn.tbox.sdk.core.exception.TboxHttpResponseException;
import cn.tbox.sdk.core.exception.TboxServerException;
import cn.tbox.sdk.core.http.HttpClient;
import cn.tbox.sdk.core.http.HttpClientConfig;
import cn.tbox.sdk.core.http.HttpResponseEvent;
import cn.tbox.sdk.model.message.MessageParser;
import cn.tbox.sdk.model.request.ChatRequest;
import cn.tbox.sdk.model.request.CompletionRequest;
import cn.tbox.sdk.model.request.ConversationListRequest;
import cn.tbox.sdk.model.request.MessageListRequest;
import cn.tbox.sdk.model.response.ConversationListResponse;
import cn.tbox.sdk.model.response.MessageListResponse;
import cn.tbox.sdk.model.response.SyncChatResponse;
import cn.tbox.sdk.model.response.SyncCompletionResponse;
import cn.tbox.sdk.model.response.TboxResponse;
import com.alibaba.fastjson.TypeReference;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class TboxClient {
    private final HttpClientConfig httpClientConfig;
    private final HttpClient httpClient;

    public TboxClient(HttpClientConfig httpClientConfig) throws TboxClientConfigException {
        if (httpClientConfig == null) {
            throw new TboxClientConfigException("httpClientConfig is null");
        }
        this.httpClientConfig = httpClientConfig;
        this.httpClient = this.createHttpClient(this.httpClientConfig);
    }

    public TboxClient(String authorization) throws TboxClientConfigException {
        this.httpClientConfig = new HttpClientConfig();
        if (authorization != null) {
            this.httpClientConfig.setAuthorization(authorization);
        }
        this.httpClient = this.createHttpClient(this.httpClientConfig);
    }

    protected HttpClient createHttpClient(HttpClientConfig config) throws TboxClientConfigException {
        return new HttpClient(config);
    }

    public Object chat(ChatRequest chatRequest) throws TboxClientConfigException, TboxHttpResponseException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("appId", chatRequest.getAppId());
        data.put("query", chatRequest.getQuery());
        data.put("userId", chatRequest.getUserId());
        if (chatRequest.getConversationId() != null) {
            data.put("conversationId", chatRequest.getConversationId());
        }
        if (chatRequest.getRequestId() != null) {
            data.put("requestId", chatRequest.getRequestId());
        }
        if (chatRequest.getClientProperties() != null) {
            data.put("clientProperties", chatRequest.getClientProperties());
        }
        if (chatRequest.getFiles() != null) {
            data.put("files", chatRequest.getFiles());
        }
        data.put("stream", chatRequest.getStream());
        if (chatRequest.getStream()) {
            Iterable<HttpResponseEvent> responseIter = this.httpClient.postStream("/api/chat", data, null, 110);
            return this.stream(responseIter, chatRequest.getMessageParser());
        }
        String responseText = this.httpClient.post("/api/chat", data, null);
        return new TboxResponse<SyncChatResponse>(responseText, new TypeReference<SyncChatResponse>(){});
    }

    public Object completion(CompletionRequest completionRequest) throws TboxClientConfigException, TboxHttpResponseException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("appId", completionRequest.getAppId());
        data.put("userId", completionRequest.getUserId());
        if (completionRequest.getRequestId() != null) {
            data.put("requestId", completionRequest.getRequestId());
        }
        if (completionRequest.getInputs() != null) {
            data.put("inputs", completionRequest.getInputs());
        }
        if (completionRequest.getClientProperties() != null) {
            data.put("clientProperties", completionRequest.getClientProperties());
        }
        if (completionRequest.getFiles() != null) {
            data.put("files", completionRequest.getFiles());
        }
        data.put("stream", completionRequest.getStream());
        if (completionRequest.getStream().booleanValue()) {
            Iterable<HttpResponseEvent> responseIter = this.httpClient.postStream("/api/completion", data, null, 110);
            return this.stream(responseIter, completionRequest.getMessageParser());
        }
        String responseText = this.httpClient.post("/api/completion", data, null);
        return new TboxResponse<SyncCompletionResponse>(responseText, new TypeReference<SyncCompletionResponse>(){});
    }

    public TboxResponse<ConversationListResponse> getConversations(ConversationListRequest conversationListRequest) throws TboxClientConfigException, TboxHttpResponseException {
        if (conversationListRequest == null) {
            throw new TboxClientConfigException("conversationListRequest is null");
        }
        if (conversationListRequest.getAppId() == null || conversationListRequest.getAppId().trim().isEmpty()) {
            throw new TboxClientConfigException("appId is required");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appId", conversationListRequest.getAppId());
        if (conversationListRequest.getUserId() != null) {
            params.put("userId", conversationListRequest.getUserId());
        }
        if (conversationListRequest.getSource() != null) {
            params.put("source", conversationListRequest.getSource());
        }
        if (conversationListRequest.getPageNum() != null) {
            params.put("pageNum", conversationListRequest.getPageNum());
        }
        if (conversationListRequest.getPageSize() != null) {
            params.put("pageSize", conversationListRequest.getPageSize());
        }
        if (conversationListRequest.getSortOrder() != null) {
            params.put("sortOrder", conversationListRequest.getSortOrder());
        }
        HashMap<String, String> stringParams = new HashMap<String, String>();
        for (Map.Entry entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            stringParams.put((String)entry.getKey(), entry.getValue().toString());
        }
        try {
            String responseText = this.httpClient.get("/api/conversation/conversations", stringParams, null);
            return new TboxResponse<ConversationListResponse>(responseText, new TypeReference<ConversationListResponse>(){});
        }
        catch (Exception e) {
            throw new TboxHttpResponseException("Failed to parse response", e);
        }
    }

    public TboxResponse<MessageListResponse> getMessages(MessageListRequest messageListRequest) throws TboxClientConfigException, TboxHttpResponseException {
        if (messageListRequest == null) {
            throw new TboxClientConfigException("messageListRequest is null");
        }
        if (messageListRequest.getConversationId() == null || messageListRequest.getConversationId().trim().isEmpty()) {
            throw new TboxClientConfigException("conversationId is required");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("conversationId", messageListRequest.getConversationId());
        if (messageListRequest.getPageNum() != null) {
            params.put("pageNum", messageListRequest.getPageNum());
        }
        if (messageListRequest.getPageSize() != null) {
            params.put("pageSize", messageListRequest.getPageSize());
        }
        if (messageListRequest.getSortOrder() != null) {
            params.put("sortOrder", messageListRequest.getSortOrder());
        }
        HashMap<String, String> stringParams = new HashMap<String, String>();
        for (Map.Entry entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            stringParams.put((String)entry.getKey(), entry.getValue().toString());
        }
        try {
            String responseText = this.httpClient.get("/api/conversation/messages", stringParams, null);
            return new TboxResponse<MessageListResponse>(responseText, new TypeReference<MessageListResponse>(){});
        }
        catch (Exception e) {
            throw new TboxHttpResponseException("Failed to parse response", e);
        }
    }

    public TboxResponse<String> createConversation(String appId) throws TboxClientConfigException, TboxHttpResponseException {
        if (appId == null || appId.trim().isEmpty()) {
            throw new TboxClientConfigException("appId is required");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("appId", appId);
        try {
            String responseText = this.httpClient.post("/api/conversation/create", data, null);
            return new TboxResponse<String>(responseText, String.class);
        }
        catch (Exception e) {
            throw new TboxHttpResponseException("Failed to parse response", e);
        }
    }

    public TboxResponse<String> uploadFile(String filePath) throws TboxClientConfigException, TboxHttpResponseException {
        if (filePath == null || filePath.trim().isEmpty()) {
            throw new TboxClientConfigException("filePath is required");
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new TboxClientConfigException("file does not exist: " + filePath);
        }
        try {
            String responseText = this.httpClient.uploadFile("/api/file/upload", file, null);
            return new TboxResponse<String>(responseText, String.class);
        }
        catch (Exception e) {
            throw new TboxHttpResponseException("Failed to upload file", e);
        }
    }

    private Iterable<Map<String, Object>> stream(final Iterable<HttpResponseEvent> responseIter, MessageParser messageParser) {
        final MessageParser parser = messageParser != null ? messageParser : new MessageParser();
        return () -> new Iterator<Map<String, Object>>(){
            private final Iterator<HttpResponseEvent> eventIterator;
            private Map<String, Object> nextData;
            private boolean hasNextCalled;
            {
                this.eventIterator = responseIter.iterator();
                this.nextData = null;
                this.hasNextCalled = false;
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextCalled) {
                    return this.nextData != null;
                }
                while (this.eventIterator.hasNext()) {
                    HttpResponseEvent event = this.eventIterator.next();
                    if (!parser.needParse(event)) continue;
                    try {
                        Map<String, Object> data = parser.parse(event);
                        String type = (String)data.get("type");
                        if ("meta".equals(type)) {
                            this.nextData = data;
                            this.hasNextCalled = true;
                            return true;
                        }
                        this.nextData = data;
                        this.hasNextCalled = true;
                        return true;
                    }
                    catch (TboxServerException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
                this.hasNextCalled = true;
                this.nextData = null;
                return false;
            }

            @Override
            public Map<String, Object> next() {
                if (!this.hasNextCalled) {
                    this.hasNext();
                }
                if (this.nextData == null) {
                    throw new NoSuchElementException();
                }
                Map<String, Object> result = this.nextData;
                this.nextData = null;
                this.hasNextCalled = false;
                return result;
            }
        };
    }
}

