package cn.tbox.sdk.model.response;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

/**
 * Base response class for Tbox API responses.
 *
 * @param <T> The type of data contained in the response
 */
public class TboxResponse<T> {
    private String errorCode;
    private String errorMsg;
    private T data;
    private String traceId;

    public TboxResponse() {
    }

    public TboxResponse(String errorCode, String errorMsg, T data, String traceId) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.data = data;
        this.traceId = traceId;
    }

    public TboxResponse(String responseText, TypeReference<T> typeReference) {
        JSONObject jsonResponse = JSON.parseObject(responseText);
        this.errorCode = jsonResponse.getString("errorCode");
        this.errorMsg = jsonResponse.getString("errorMsg");
        this.traceId = jsonResponse.getString("traceId");
        
        Object dataValue = jsonResponse.get("data");
        if (dataValue == null) {
            this.data = null;
        } else if (dataValue instanceof JSONObject) {
            this.data = JSON.parseObject(((JSONObject) dataValue).toJSONString(), typeReference);
        } else {
            this.data = (T) dataValue;
        }
    }

    public TboxResponse(String responseText, Class<T> dataClass) {
        JSONObject jsonResponse = JSON.parseObject(responseText);
        this.errorCode = jsonResponse.getString("errorCode");
        this.errorMsg = jsonResponse.getString("errorMsg");
        this.traceId = jsonResponse.getString("traceId");
        
        Object dataValue = jsonResponse.get("data");
        if (dataValue == null) {
            this.data = null;
        } else if (dataValue instanceof JSONObject) {
            this.data = JSON.parseObject(((JSONObject) dataValue).toJSONString(), dataClass);
        } else {
            this.data = (T) dataValue;
        }
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    /**
     * Check if the response is successful.
     *
     * @return true if errorCode is "0", false otherwise
     */
    public boolean isSuccess() {
        return "0".equals(errorCode);
    }

    @Override
    public String toString() {
        return "TboxResponse{" +
                "errorCode='" + errorCode + '\'' +
                ", errorMsg='" + errorMsg + '\'' +
                ", data=" + data +
                ", traceId='" + traceId + '\'' +
                '}';
    }
} 