package cn.tbox.sdk.model.response;

import cn.tbox.sdk.model.message.Message;
import java.util.List;

/**
 * Response model for message list.
 */
public class MessageListResponse {

    /**
     * 当前页码
     */
    private Integer currentPage;

    /**
     * 每页条数
     */
    private Integer pageSize;

    /**
     * 总条数
     */
    private Integer total;

    /**
     * 消息列表
     */
    private List<Message> messages;

    public MessageListResponse() {
    }

    public MessageListResponse(List<Message> messages) {
        this.messages = messages;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public Integer getTotal() {
        return total;
    }

    public List<Message> getMessages() {
        return messages;
    }

    @Override
    public String toString() {
        return "MessageListResponse{" +
                "messages=" + messages +
                '}';
    }
} 