package cn.tbox.sdk.model.request;

/**
 * Request model for querying message list.
 */
public class MessageListRequest {

    /**
     * 会话ID（必填）
     */
    private String conversationId;

    /**
     * 页码（可选），默认1
     */
    private Integer pageNum;

    /**
     * 每页条数（可选），默认10, 最大50
     */
    private Integer pageSize;

    /**
     * 排序方式（可选），默认DESC
     * ASC-升序
     * DESC-降序
     */
    private String sortOrder;

    public MessageListRequest() {
    }

    public MessageListRequest(String conversationId) {
        this.conversationId = conversationId;
    }

    public MessageListRequest(String conversationId, Integer pageNum, Integer pageSize, String sortOrder) {
        this.conversationId = conversationId;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.sortOrder = sortOrder;
    }

    public String getConversationId() {
        return conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    /**
     * Sort order enum values.
     */
    public static class SortOrder {
        public static final String ASC = "ASC";
        public static final String DESC = "DESC";
    }

    @Override
    public String toString() {
        return "MessageListRequest{" +
                "conversationId='" + conversationId + '\'' +
                ", pageNum=" + pageNum +
                ", pageSize=" + pageSize +
                ", sortOrder='" + sortOrder + '\'' +
                '}';
    }
} 