package cn.tbox.sdk.model.request;

/**
 * Request model for querying conversation list.
 */
public class ConversationListRequest {

    /**
     * 智能体ID（必填）
     */
    private String appId;

    /**
     * 用户ID（可选）
     * 发起对话时指定，需要在智能体内唯一。不传返回全部用户的会话列表
     */
    private String userId;

    /**
     * 渠道（可选），用于筛选指定渠道的对话，不传返回全部
     * AGENT_SDK-SDK渠道
     * OPENAPI-OpenAPI渠道
     * IOT_DEVICE--IOT SDK渠道
     */
    private String source;

    /**
     * 页码（可选），默认1
     */
    private Integer pageNum;

    /**
     * 每页条数（可选），默认10, 最大50
     */
    private Integer pageSize;

    /**
     * 排序方式（可选），默认DESC
     * ASC-升序
     * DESC-降序
     */
    private String sortOrder;

    public ConversationListRequest() {
    }

    public ConversationListRequest(String appId) {
        this.appId = appId;
    }

    public ConversationListRequest(String appId, String userId, String source, 
                                 Integer pageNum, Integer pageSize, String sortOrder) {
        this.appId = appId;
        this.userId = userId;
        this.source = source;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.sortOrder = sortOrder;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    /**
     * Sort order enum values.
     */
    public static class SortOrder {
        public static final String ASC = "ASC";
        public static final String DESC = "DESC";
    }

    /**
     * Source enum values.
     */
    public static class Source {
        public static final String AGENT_SDK = "AGENT_SDK";
        public static final String OPENAPI = "OPENAPI";
        public static final String IOT_DEVICE = "IOT_DEVICE";
    }

    @Override
    public String toString() {
        return "ConversationListRequest{" +
                "appId='" + appId + '\'' +
                ", userId='" + userId + '\'' +
                ", source='" + source + '\'' +
                ", pageNum=" + pageNum +
                ", pageSize=" + pageSize +
                ", sortOrder='" + sortOrder + '\'' +
                '}';
    }
} 