package cn.tbox.sdk.model.request;

import java.util.List;
import java.util.Map;

import cn.tbox.sdk.model.file.File;
import cn.tbox.sdk.model.message.MessageParser;

public class CompletionRequest {

    /**
     * 智能体ID（必填）
     */
    private String appId;

    /**
     * 用户ID（必填）
     */
    private String userId;

    /**
     * 输入参数（选填）
     */
    private Map<String, Object> inputs = null;

    /**
     * 请求ID（可选）
     */
    private String requestId = null;

    /**
     * 消息解析器（可选）
     */
    private MessageParser messageParser = null;

    /**
     * 文件列表（可选）
     */
    private List<File> files = null;

    /**
     * 是否流式返回（可选，默认true）
     */
    private Boolean stream = true;

    /**
     * 扩展属性（可选）
     */
    private Map<String, Object> clientProperties = null;

    public CompletionRequest(String appId, String userId) {
        this.appId = appId;
        this.userId = userId;
    }

    public CompletionRequest(String appId, String userId, Map<String, Object> inputs) {
        this.appId = appId;
        this.userId = userId;
        this.inputs = inputs;
    }

    public CompletionRequest(String appId, String userId, Map<String, Object> inputs, String requestId, MessageParser messageParser, Map<String, Object> clientProperties, List<File> files, Boolean stream) {
        this.appId = appId;
        this.userId = userId;
        this.inputs = inputs;
        this.requestId = requestId;
        this.messageParser = messageParser;
        this.clientProperties = clientProperties;
        this.files = files;
        this.stream = stream;
    }

    public String getAppId() {
        return appId;
    }

    public String getUserId() {
        return userId;
    }

    public Map<String, Object> getInputs() {
        return inputs;
    }

    public String getRequestId() {
        return requestId;
    }

    public MessageParser getMessageParser() {
        return messageParser;
    }

    public Map<String, Object> getClientProperties() {
        return clientProperties;
    }

    public List<File> getFiles() {
        return files;
    }

    public Boolean getStream() {
        return stream;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setInputs(Map<String, Object> inputs) {
        this.inputs = inputs;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setMessageParser(MessageParser messageParser) {
        this.messageParser = messageParser;
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this.clientProperties = clientProperties;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }
}
