package cn.tbox.sdk.model.request;

import java.util.List;
import java.util.Map;

import cn.tbox.sdk.model.file.File;
import cn.tbox.sdk.model.message.MessageParser;

public class ChatRequest {

    /**
     * 智能体ID（必填）
     */
    private String appId;

    /**
     * 用户提问（必填）
     */
    private String query;

    /**
     * 用户ID（必填）
     */
    private String userId;

    /**
     * 会话ID（可选）
     */
    private String conversationId = null;

    /**
     * 请求ID（可选）
     */
    private String requestId = null;

    /**
     * 扩展属性（可选）
     */
    private Map<String, Object> clientProperties = null;

    /**
     * 文件列表（可选）
     */
    private List<File> files = null;

    /**
     * 是否流式返回（可选，默认true）
     */
    private boolean stream = true;

    /**
     * 消息解析器（可选）
     */
    private MessageParser messageParser = null;

    public ChatRequest(String appId, String query, String userId) {
        this.appId = appId;
        this.query = query;
        this.userId = userId;
    }

    public ChatRequest(String appId, String query, String userId, String conversationId) {
        this.appId = appId;
        this.query = query;
        this.userId = userId;
        this.conversationId = conversationId;
    }

    public ChatRequest(String appId, String query, String userId, String conversationId, String requestId, Map<String, Object> clientProperties, List<File> files, boolean stream, MessageParser messageParser) {
        this.appId = appId;
        this.query = query;
        this.userId = userId;
        this.conversationId = conversationId;
        this.requestId = requestId;
        this.clientProperties = clientProperties;
        this.files = files;
        this.stream = stream;
        this.messageParser = messageParser;
    }

    public String getAppId() {
        return appId;
    }

    public String getQuery() {
        return query;
    }

    public String getUserId() {
        return userId;
    }

    public String getConversationId() {
        return conversationId;
    }

    public String getRequestId() {
        return requestId;
    }

    public Map<String, Object> getClientProperties() {
        return clientProperties;
    }

    public List<File> getFiles() {
        return files;
    }

    public boolean getStream() {
        return stream;
    }

    public MessageParser getMessageParser() {
        return messageParser;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this.clientProperties = clientProperties;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setMessageParser(MessageParser messageParser) {
        this.messageParser = messageParser;
    }
}
