package cn.tbox.sdk.model.message;

/**
 * File model representing a file in a message.
 */
public class MessageFile {

    /**
     * 文件类型
     */
    private String type;

    /**
     * 预览链接（有效期 24 h）
     */
    private String url;

    /**
     * 链接过期时间，时间戳，单位 s
     */
    private Long expireAt;

    public MessageFile() {
    }

    public MessageFile(String type, String url, Long expireAt) {
        this.type = type;
        this.url = url;
        this.expireAt = expireAt;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Long getExpireAt() {
        return expireAt;
    }

    public void setExpireAt(Long expireAt) {
        this.expireAt = expireAt;
    }

    /**
     * File type enum values.
     */
    public static class Type {
        public static final String IMAGE = "IMAGE";
        public static final String AUDIO = "AUDIO";
        public static final String VIDEO = "VIDEO";
        public static final String FILE = "FILE";
    }

    @Override
    public String toString() {
        return "MessageFile{" +
                ", type='" + type + '\'' +
                ", url='" + url + '\'' +
                ", expireAt=" + expireAt +
                '}';
    }
} 