package cn.tbox.sdk.model.message;

import java.util.List;

/**
 * Message model representing a message in the Tbox API.
 */
public class Message {

    /**
     * 消息ID
     */
    private String messageId;

    /**
     * 会话ID
     */
    private String conversationId;

    /**
     * 智能体ID
     */
    private String appId;

    /**
     * 提问内容
     */
    private String query;

    /**
     * 回答列表
     */
    private List<Answer> answers;

    /**
     * 文件列表
     */
    private List<MessageFile> files;

    /**
     * 创建时间
     */
    private Long createAt;

    /**
     * 更新时间
     */
    private Long updateAt;

    /**
     * 状态
     * 
     * @see Status
     */
    private String status;

    public Message() {
    }

    public Message(String messageId, String conversationId, String appId, String query, 
                  List<Answer> answers, List<MessageFile> files, Long createAt, Long updateAt, String status) {
        this.messageId = messageId;
        this.conversationId = conversationId;
        this.appId = appId;
        this.query = query;
        this.answers = answers;
        this.files = files;
        this.createAt = createAt;
        this.updateAt = updateAt;
        this.status = status;
    }

    public static class Answer {
        /**
         * 回答类型
         */
        private String lane;

        /**
         * 回答类型
         * 
         * @see MediaType
         */
        private String mediaType;

        /**
         * 回答内容
         */
        private String text;

        /**
         * 图片链接（有效期 24 小时）
         */
        private List<String> url;

        /**
         * 过期时间
         */
        private Long expireAt;

        public Answer() {
        }

        public Answer(String lane, String mediaType, String text, List<String> url, Long expireAt) {
            this.lane = lane;
            this.mediaType = mediaType;
            this.text = text;
            this.url = url;
            this.expireAt = expireAt;
        }

        public String getLane() {
            return lane;
        }

        public void setLane(String lane) {
            this.lane = lane;
        }

        public String getMediaType() {
            return mediaType;
        }

        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public List<String> getUrl() {
            return url;
        }

        public void setUrl(List<String> url) {
            this.url = url;
        }

        public Long getExpireAt() {
            return expireAt;
        }

        public void setExpireAt(Long expireAt) {
            this.expireAt = expireAt;
        }

        /**
         * Media type enum values.
         */
        public static class MediaType {
            /**
             * 文本
             */
            public static final String TEXT = "text";

            /**
             * 图片
             */
            public static final String IMAGE = "image";
        }

        @Override
        public String toString() {
            return "Answer{" +
                    "lane='" + lane + '\'' +
                    ", mediaType='" + mediaType + '\'' +
                    ", text='" + text + '\'' +
                    ", url=" + url +
                    ", expireAt=" + expireAt +
                    '}';
        }        
    }

    public String getMessageId() {
        return messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getConversationId() {
        return conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<Answer> getAnswers() {
        return answers;
    }

    public void setAnswers(List<Answer> answers) {
        this.answers = answers;
    }

    public List<MessageFile> getFiles() {
        return files;
    }

    public void setFiles(List<MessageFile> files) {
        this.files = files;
    }

    public Long getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public Long getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * Status enum values for messages.
     */
    public static class Status {
        public static final String SUCCESS = "SUCCESS";
        public static final String ERROR = "ERROR";
        public static final String BLOCK = "BLOCK";
        public static final String PENDING = "PENDING";
    }

    @Override
    public String toString() {
        return "Message{" +
                "messageId='" + messageId + '\'' +
                ", conversationId='" + conversationId + '\'' +
                ", appId='" + appId + '\'' +
                ", query='" + query + '\'' +
                ", answers=" + answers +
                ", files=" + files +
                ", createAt=" + createAt +
                ", updateAt=" + updateAt +
                ", status='" + status + '\'' +
                '}';
    }
} 