package cn.tbox.sdk.model.file;

/**
 * Definition of File
 */
public class File {

    /**
     * file ID, uploaded file ID via File Upload API
     */
    private String fileId;

    /**
     * file type, supported types include IMAGE, AUDIO, VIDEO, FILE
     */
    private String type;

    /**
     * Constructs a File instance with specified file ID and file type
     * @param fileId Unique file ID obtained from File Upload API
     * @param type File type (IMAGE/AUDIO/VIDEO/FILE)
     */
    public File(String fileId, String type) {
        this.fileId = fileId;
        this.type = type;
    }

    /**
     * Get the file ID
     * @return File ID string
     */
    public String getFileId() {
        return fileId;
    }

    /**
     * Update the file ID
     * @param fileId uploaded file ID via File Upload API
     */
    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    /**
     * Get the file type
     * @return File type (IMAGE/AUDIO/VIDEO/FILE)
     */
    public String getType() {
        return type;
    }

    /**
     * Update the file type
     * @param type supported types include IMAGE, AUDIO, VIDEO, FILE
     */
    public void setType(String type) {
        this.type = type;
    }
}
