package cn.tbox.sdk.model.conversation;

/**
 * Conversation model representing a conversation in the Tbox API.
 */
public class Conversation {

    /**
     * 会话ID
     */
    private String conversationId;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 来源
     */
    private String source;

    /**
     * 创建时间
     */
    private Long createAt;

    public Conversation() {
    }

    public Conversation(String conversationId, String userId, String source, Long createAt) {
        this.conversationId = conversationId;
        this.userId = userId;
        this.source = source;
        this.createAt = createAt;
    }

    public String getConversationId() {
        return conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Long getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    /**
     * Source enum values for conversations.
     */
    public static class Source {
        public static final String AGENT_SDK = "AGENT_SDK";
        public static final String OPENAPI = "OPENAPI";
        public static final String IOT_DEVICE = "IOT_DEVICE";
    }

    @Override
    public String toString() {
        return "Conversation{" +
                "conversationId='" + conversationId + '\'' +
                ", userId='" + userId + '\'' +
                ", source='" + source + '\'' +
                ", createAt=" + createAt +
                '}';
    }
} 