package cn.tbox.sdk.example;

import cn.tbox.sdk.TboxClient;
import cn.tbox.sdk.model.response.TboxResponse;
import cn.tbox.sdk.core.exception.TboxClientConfigException;
import cn.tbox.sdk.core.exception.TboxHttpResponseException;

/**
 * Example demonstrating how to use the create conversation API.
 */
public class CreateConversationExample {
    
    public static void main(String[] args) {
        try {
            // Create a Tbox client with your authorization token
            TboxClient client = new TboxClient("your_authorization_token_here");
            
            // Example 1: Basic conversation creation
            TboxResponse<String> basicResponse = client.createConversation("2025*****4259");
            
            if (basicResponse.isSuccess()) {
                System.out.println("Conversation created successfully!");
                String conversationId = basicResponse.getData();
                System.out.println("Conversation ID: " + conversationId);
                System.out.println("You can now use this conversation ID for chat");
            } else {
                System.out.println("Failed to create conversation: " + basicResponse.getErrorMsg());
            }
        } catch (TboxClientConfigException e) {
            System.err.println("Configuration error: " + e.getMessage());
        } catch (TboxHttpResponseException e) {
            System.err.println("HTTP response error: " + e.getMessage());
        } catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
        }
    }
} 