package cn.tbox.sdk.example;

import cn.tbox.sdk.TboxClient;
import cn.tbox.sdk.model.conversation.Conversation;
import cn.tbox.sdk.model.request.ConversationListRequest;
import cn.tbox.sdk.model.response.ConversationListResponse;
import cn.tbox.sdk.model.response.TboxResponse;
import cn.tbox.sdk.core.exception.TboxClientConfigException;
import cn.tbox.sdk.core.exception.TboxHttpResponseException;

import java.util.List;

/**
 * Example demonstrating how to use the conversation list API.
 */
public class ConversationListExample {
    
    public static void main(String[] args) {
        try {
            // Create a Tbox client with your authorization token
            TboxClient client = new TboxClient("your_authorization_token_here");
            
            // Example 1: Basic conversation list request
            ConversationListRequest basicRequest = new ConversationListRequest("2025*****0812");
            TboxResponse<ConversationListResponse> basicResponse = client.getConversations(basicRequest);
            
            if (basicResponse.isSuccess()) {
                System.out.println("Basic request successful!");
                List<Conversation> conversations = basicResponse.getData().getConversations();
                for (Conversation conv : conversations) {
                    System.out.println("Conversation ID: " + conv.getConversationId());
                    System.out.println("User ID: " + conv.getUserId());
                    System.out.println("Source: " + conv.getSource());
                    System.out.println("Created at: " + conv.getCreateAt());
                    System.out.println("---");
                }
            } else {
                System.out.println("Request failed: " + basicResponse.getErrorMsg());
            }
            
            // Example 2: Advanced conversation list request with filters
            ConversationListRequest advancedRequest = new ConversationListRequest();
            advancedRequest.setAppId("2025*****0812");
            advancedRequest.setUserId("test_user_zs");
            advancedRequest.setSource(ConversationListRequest.Source.AGENT_SDK);
            advancedRequest.setPageNum(1);
            advancedRequest.setPageSize(20);
            advancedRequest.setSortOrder(ConversationListRequest.SortOrder.DESC);
            
            TboxResponse<ConversationListResponse> advancedResponse = client.getConversations(advancedRequest);
            
            if (advancedResponse.isSuccess()) {
                System.out.println("Advanced request successful!");
                List<Conversation> conversations = advancedResponse.getData().getConversations();
                System.out.println("Found " + conversations.size() + " conversations");
                
                conversations.forEach(conv -> {
                    System.out.println("Conversation: " + conv.getConversationId());
                });
            } else {
                System.out.println("Advanced request failed: " + advancedResponse.getErrorMsg());
            }
            
        } catch (TboxClientConfigException e) {
            System.err.println("Configuration error: " + e.getMessage());
        } catch (TboxHttpResponseException e) {
            System.err.println("HTTP response error: " + e.getMessage());
        } catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
        }
    }
} 