package cn.tbox.sdk.example;

import cn.tbox.sdk.TboxClient;
import cn.tbox.sdk.core.http.HttpClientConfig;
import cn.tbox.sdk.core.exception.TboxClientConfigException;
import cn.tbox.sdk.core.exception.TboxHttpResponseException;
import cn.tbox.sdk.model.request.ChatRequest;
import cn.tbox.sdk.model.request.CompletionRequest;

import java.util.HashMap;
import java.util.Map;

/**
 * Example demonstrating the use of TboxClient.
 */
public class ChatAndCompletionExample {

    /**
     * Main method with examples.
     *
     * @param args Command line arguments (not used)
     */
    public static void main(String[] args) throws TboxClientConfigException, TboxHttpResponseException {
        try {
            // Create a client with just authorization token
            TboxClient client = new TboxClient("your-authorization-token-here");
            
            // Example 1: Simple streaming chat
            System.out.println("Example 1: Simple streaming chat");
            Iterable<Map<String, Object>> chatStream = (Iterable<Map<String, Object>>) client.chat(
                new ChatRequest("your-app-id-here", "Hello, how are you?", "user-id-123")
            );
            
            for (Map<String, Object> response : chatStream) {
                System.out.println("Received chunk: " + response);
            }
            
            // Example 2: Completion with custom inputs
            System.out.println("\nExample 2: Completion with custom inputs");
            Map<String, Object> inputs = new HashMap<>();
            inputs.put("prompt", "Generate a Java function to calculate factorial");
            
            Iterable<Map<String, Object>> completionStream = (Iterable<Map<String, Object>>) client.completion(
                new CompletionRequest("your-app-id-here", "user-id-123", inputs)
            );
            
            for (Map<String, Object> response : completionStream) {
                System.out.println("Received completion chunk: " + response);
            }
        } catch (TboxClientConfigException e) {
            System.err.println("Configuration error: " + e.getMessage());
            e.printStackTrace();
        }
    }
    
    /**
     * Helper method to print results.
     *
     * @param result Result map to print
     */
    private static void printResult(Map<String, Map<String, Object>> result) {
        for (Map.Entry<String, Map<String, Object>> entry : result.entrySet()) {
            String lane = entry.getKey();
            Map<String, Object> laneData = entry.getValue();
            
            System.out.println("Lane: " + lane);
            System.out.println("Type: " + laneData.get("type"));
            System.out.println("Data: " + laneData.get("data"));
        }
    }
} 