package cn.tbox.sdk.core.exception;

import java.util.Map;

/**
 * Tbox server exception.
 * Used to identify tbox server exceptions.
 */
public class TboxServerException extends TboxClientException {
    /**
     * Error context holding detailed error information.
     */
    private Map<String, Object> errorContext;

    public TboxServerException(String message) {
        super(message);
    }

    public TboxServerException(String message, Throwable cause) {
        super(message, cause);
    }

    public Map<String, Object> getErrorContext() {
        return errorContext;
    }

    public void setErrorContext(Map<String, Object> errorContext) {
        this.errorContext = errorContext;
    }
} 