/*
 * Decompiled with CFR 0.152.
 */
package cn.tbox.sdk;

import cn.tbox.sdk.core.exception.TboxClientConfigException;
import cn.tbox.sdk.core.exception.TboxServerException;
import cn.tbox.sdk.core.http.HttpClient;
import cn.tbox.sdk.core.http.HttpClientConfig;
import cn.tbox.sdk.core.http.HttpResponseEvent;
import cn.tbox.sdk.model.message.MessageParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class TboxClient {
    private final HttpClientConfig httpClientConfig;
    private final HttpClient httpClient;

    public TboxClient(HttpClientConfig httpClientConfig) throws TboxClientConfigException {
        if (httpClientConfig == null) {
            throw new TboxClientConfigException("httpClientConfig is null");
        }
        this.httpClientConfig = httpClientConfig;
        this.httpClient = this.createHttpClient(this.httpClientConfig);
    }

    public TboxClient(String authorization) throws TboxClientConfigException {
        this.httpClientConfig = new HttpClientConfig();
        if (authorization != null) {
            this.httpClientConfig.setAuthorization(authorization);
        }
        this.httpClient = this.createHttpClient(this.httpClientConfig);
    }

    protected HttpClient createHttpClient(HttpClientConfig config) throws TboxClientConfigException {
        return new HttpClient(config);
    }

    public Iterable<Map<String, Object>> chat(String appId, String query, String userId, String conversationId, String requestId, Map<String, Object> inputs, String version, boolean withMeta, MessageParser messageParser, Map<String, Object> clientProperties) throws TboxClientConfigException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("appId", appId);
        data.put("query", query);
        if (conversationId != null) {
            data.put("conversationId", conversationId);
        }
        if (requestId != null) {
            data.put("requestId", requestId);
        }
        if (inputs != null) {
            data.put("inputs", inputs);
        }
        if (userId != null) {
            data.put("userId", userId);
        }
        if (clientProperties != null) {
            data.put("clientProperties", clientProperties);
        }
        if (version != null) {
            data.put("version", version);
        }
        Iterable<HttpResponseEvent> responseIter = this.httpClient.postStream("/api/chat", data, null, 110);
        return this.stream(responseIter, messageParser, withMeta);
    }

    public Iterable<Map<String, Object>> chat(String appId, String query, String userId) throws TboxClientConfigException {
        return this.chat(appId, query, userId, null, null, null, null, false, null, null);
    }

    public Map<String, Map<String, Object>> chatSync(String appId, String query, String userId, String conversationId, String requestId, Map<String, Object> inputs, String version, Map<String, Object> clientProperties) throws TboxClientConfigException {
        MessageParser parser = new MessageParser();
        Iterable<Map<String, Object>> events = this.chat(appId, query, userId, conversationId, requestId, inputs, version, false, parser, clientProperties);
        for (Map<String, Object> map : events) {
        }
        return parser.getAnswersHolder();
    }

    public Map<String, Map<String, Object>> chatSync(String appId, String query, String userId) throws TboxClientConfigException {
        return this.chatSync(appId, query, userId, null, null, null, null, null);
    }

    public Iterable<Map<String, Object>> completion(String appId, Map<String, Object> inputs, String userId, String conversationId, String requestId, String version, boolean withMeta, MessageParser messageParser, Map<String, Object> clientProperties) throws TboxClientConfigException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("appId", appId);
        if (conversationId != null) {
            data.put("conversationId", conversationId);
        }
        if (requestId != null) {
            data.put("requestId", requestId);
        }
        if (inputs != null) {
            data.put("inputs", inputs);
        }
        if (userId != null) {
            data.put("userId", userId);
        }
        if (clientProperties != null) {
            data.put("clientProperties", clientProperties);
        }
        if (version != null) {
            data.put("version", version);
        }
        Iterable<HttpResponseEvent> responseIter = this.httpClient.postStream("/api/completion", data, null, 110);
        return this.stream(responseIter, messageParser, withMeta);
    }

    public Iterable<Map<String, Object>> completion(String appId, Map<String, Object> inputs, String userId) throws TboxClientConfigException {
        return this.completion(appId, inputs, userId, null, null, null, false, null, null);
    }

    public Map<String, Map<String, Object>> completionSync(String appId, Map<String, Object> inputs, String userId, String conversationId, String requestId, String version, Map<String, Object> clientProperties) throws TboxClientConfigException {
        MessageParser parser = new MessageParser();
        Iterable<Map<String, Object>> events = this.completion(appId, inputs, userId, conversationId, requestId, version, false, parser, clientProperties);
        for (Map<String, Object> map : events) {
        }
        return parser.getAnswersHolder();
    }

    public Map<String, Map<String, Object>> completionSync(String appId, Map<String, Object> inputs, String userId) throws TboxClientConfigException {
        return this.completionSync(appId, inputs, userId, null, null, null, null);
    }

    private Iterable<Map<String, Object>> stream(final Iterable<HttpResponseEvent> responseIter, MessageParser messageParser, final boolean withMeta) {
        final MessageParser parser = messageParser != null ? messageParser : new MessageParser();
        return () -> new Iterator<Map<String, Object>>(){
            private final Iterator<HttpResponseEvent> eventIterator;
            private Map<String, Object> nextData;
            private boolean hasNextCalled;
            {
                this.eventIterator = responseIter.iterator();
                this.nextData = null;
                this.hasNextCalled = false;
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextCalled) {
                    return this.nextData != null;
                }
                while (this.eventIterator.hasNext()) {
                    HttpResponseEvent event = this.eventIterator.next();
                    if (!parser.needParse(event)) continue;
                    try {
                        Map<String, Object> data = parser.parse(event);
                        String type = (String)data.get("type");
                        if ("meta".equals(type)) {
                            if (!withMeta) continue;
                            this.nextData = data;
                            this.hasNextCalled = true;
                            return true;
                        }
                        this.nextData = data;
                        this.hasNextCalled = true;
                        return true;
                    }
                    catch (TboxServerException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
                this.hasNextCalled = true;
                this.nextData = null;
                return false;
            }

            @Override
            public Map<String, Object> next() {
                if (!this.hasNextCalled) {
                    this.hasNext();
                }
                if (this.nextData == null) {
                    throw new NoSuchElementException();
                }
                Map<String, Object> result = this.nextData;
                this.nextData = null;
                this.hasNextCalled = false;
                return result;
            }
        };
    }
}

