package cn.tbox.sdk.core.http;

/**
 * HTTP client configuration.
 */
public class HttpClientConfig {
    /**
     * Authorization, in HTTP protocol header's authorization.
     */
    private String authorization;

    /**
     * Schema, https or http.
     */
    private String schema;

    /**
     * Host, in HTTP protocol header's host.
     */
    private String host;

    public HttpClientConfig() {
        this.schema = "https";
        this.host = "api.tbox.cn";
    }

    public HttpClientConfig(String authorization) {
        this();
        this.authorization = authorization;
    }

    public HttpClientConfig(String authorization, String schema, String host) {
        this.authorization = authorization;
        this.schema = schema != null ? schema : "https";
        this.host = host != null ? host : "api.tbox.cn";
    }

    public String getAuthorization() {
        return authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public String getSchema() {
        return schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }
} 