/*
 * Decompiled with CFR 0.152.
 */
package cn.tbox.sdk.example;

import cn.tbox.sdk.TboxClient;
import cn.tbox.sdk.core.exception.TboxClientConfigException;
import cn.tbox.sdk.core.http.HttpClientConfig;
import java.util.HashMap;
import java.util.Map;

public class TboxExample {
    public static void main(String[] args) {
        try {
            TboxClient client = new TboxClient("your-authorization-token-here");
            System.out.println("Example 1: Simple synchronous chat");
            Map<String, Map<String, Object>> chatResult = client.chatSync("your-app-id-here", "Hello, how are you?", null);
            TboxExample.printResult(chatResult);
            System.out.println("\nExample 2: Streaming chat with conversation ID");
            String conversationId = "conversation-123";
            Iterable<Map<String, Object>> chatStream = client.chat("your-app-id-here", "Tell me more about Java programming", conversationId);
            for (Map<String, Object> response : chatStream) {
                System.out.println("Received chunk: " + response);
            }
            System.out.println("\nExample 3: Completion with custom inputs");
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            inputs.put("prompt", "Generate a Java function to calculate factorial");
            Map<String, Map<String, Object>> completionResult = client.completionSync("your-app-id-here", inputs, conversationId);
            TboxExample.printResult(completionResult);
            System.out.println("\nExample 4: Advanced client configuration");
            HttpClientConfig config = new HttpClientConfig("your-authorization-token-here", "https", "custom-host.example.com");
            TboxClient tboxClient = new TboxClient(config);
        }
        catch (TboxClientConfigException e) {
            System.err.println("Configuration error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void printResult(Map<String, Map<String, Object>> result) {
        for (Map.Entry<String, Map<String, Object>> entry : result.entrySet()) {
            String lane = entry.getKey();
            Map<String, Object> laneData = entry.getValue();
            System.out.println("Lane: " + lane);
            System.out.println("Type: " + laneData.get("type"));
            System.out.println("Data: " + laneData.get("data"));
        }
    }
}

