package cn.tbox.sdk.core.exception;

/**
 * HTTP response exception.
 * Used to identify client HTTP request response exceptions.
 */
public class TboxHttpResponseException extends TboxClientException {
    private int statusCode;
    
    public TboxHttpResponseException(String message) {
        super(message);
    }
    
    public TboxHttpResponseException(int statusCode, String message) {
        super(message);
        this.statusCode = statusCode;
    }

    public TboxHttpResponseException(String message, Throwable cause) {
        super(message, cause);
    }
    
    public int getStatusCode() {
        return statusCode;
    }
} 